% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_io_functions.R
\name{save_centroid_data}
\alias{save_centroid_data}
\title{Save Centroid Data}
\usage{
save_centroid_data(
  data,
  file_path = NULL,
  scale = "huc8",
  nutrient = "nitrogen",
  analysis_type = "centroids",
  year = format(Sys.Date(), "\%Y")
)
}
\arguments{
\item{data}{Data frame. Data with centroid coordinates}

\item{file_path}{Character. Output file path (should end in .csv). If NULL, auto-generated}

\item{scale}{Character. Spatial scale for file naming}

\item{nutrient}{Character. Nutrient type for file naming}

\item{analysis_type}{Character. Analysis type for file naming}

\item{year}{Numeric. Year for file naming}
}
\value{
Character. Path to saved file
}
\description{
Save centroid data to CSV file for transition probability analysis
}
\examples{
\donttest{
# Create some example data first
results <- run_builtin_analysis(scale = "county", year = 2016, include_wwtp = TRUE)

# Save centroids for transition analysis
if ("integrated" \%in\% names(results) && "nitrogen" \%in\% names(results$integrated)) {
  centroids <- add_centroid_coordinates(results$integrated$nitrogen)
  save_centroid_data(centroids, scale = "county", nutrient = "nitrogen")
}
}
}
