% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/manifesto.R
\name{mp_maindataset}
\alias{mp_maindataset}
\title{Access the Manifesto Project's Main Dataset}
\usage{
mp_maindataset(version = "current", apikey = NULL, cache = TRUE)
}
\arguments{
\item{version}{Specify the version of the dataset you want to access. Use
"current" to obtain the most recent, or use
\code{\link{mp_coreversions}} for a list of available
versions.}

\item{apikey}{API key to use. Defaults to \code{NULL}, resulting in using
the API key set via \code{\link{mp_setapikey}}.}

\item{cache}{Boolean flag indicating whether to use locally cached data if
             available.}
}
\value{
The Manifesto Project Main Dataset with classes \code{data.frame} and
\code{\link[dplyr]{tbl_df}}
}
\description{
Gets the Manifesto Project's Main Dataset from the project's web API or
the local cache, if it was already downloaded before.
}
\examples{
\dontrun{
mpds <- mp_maindataset()
head(mpds)
median(subset(mpds, countryname == "Switzerland")$rile, na.rm = TRUE)
}
}

