% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_prior_object_functions.R
\name{makemyprior_gui}
\alias{makemyprior_gui}
\title{Graphical prior construction}
\usage{
makemyprior_gui(prior, guide = FALSE, no_pc = FALSE)
}
\arguments{
\item{prior}{An object from \link[makemyprior]{make_prior}.}

\item{guide}{Logical, whether to open the guide directly when the app is started. Default is \code{FALSE}. The guide
can be opened in the app at any time.}

\item{no_pc}{Turn off computation of the PC prior on splits when using the shiny-app, to avoid slow computations.
Upon closing, the PC priors will be computed. Default is \code{FALSE}.}
}
\value{
Returns an object that can be sent to \link[makemyprior]{inference_stan} or \link[makemyprior]{inference_inla}.
Can also be sent to \link[makemyprior]{makemyprior_gui} again.
}
\description{
This functions opens a shiny app where the specified prior can be seen, and changed.
}
\examples{
\dontrun{

vignette("make_prior", package = "makemyprior")

}

if (interactive()){
   ex_prior <- makemyprior_example_model()
   new_prior <- makemyprior_gui(ex_prior)
}

}
\keyword{gui}
