\name{maicWt}
\alias{maicWt}
\title{Estimates the MAIC weights
}
\description{Estimates the MAIC weights for each individual in the IPD. Should only be used after it is ascertained that AD is indeed within the convex hull of IPD.
}
\usage{
maicWt(ipd, ad, max.it = 25)
}
\arguments{
  \item{ipd}{a dataframe with n row and p coln, where n is number of subjects and p is the number of variables used in matching.
}
  \item{ad}{a dataframe with 1 row and p coln. The matching variables should be in the same order as that in \code{ipd}. The function does not check this.
}
  \item{max.it}{maximum iteration passed to optim(). if \code{ad} is within \code{ipd} convex hull, then the default 25 iterations of optim() should be enough. }
}
\details{The main code are taken from Philippo (2016). It returns the following:
}
\value{
  \item{optim.out}{results of optim()}
  \item{maic.wt}{MAIC un-scaled weights for each subject in the IPD set}
  \item{maic.wt.rs}{re-scaled weights which add up to the original total sample size, i.e. nrow(ipd)}
  \item{ipd.ess}{effective sample size}
  \item{ipd.wtsumm}{weighted summary statistics of the matching variables after matching. they should be identical to the input AD when AD is within the IPD convex hull.}
}
\references{Phillippo DM, Ades AE, Dias S, et al. (2016). Methods for population-adjusted indirect comparisons in submissions to NICE. NICE Decision Support Unit Technical Support Document 18.
}
\author{
Lillian Yau
}
\examples{
## eAD[1,] is scenario A in the reference manuscript
m1 <- maicWt(eIPD, eAD[1,2:3])
}
