% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{segmentation}
\alias{segmentation}
\alias{image_connect}
\alias{image_split}
\alias{image_fuzzycmeans}
\title{Image Segmentation}
\usage{
image_connect(image, connectivity = 4)

image_split(image, keep_color = TRUE)

image_fuzzycmeans(image, min_pixels = 1, smoothing = 1.5)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{connectivity}{number neighbor colors which are considered part of a unique object}

\item{keep_color}{if TRUE the output images retain the color of the input pixel.
If FALSE all matching pixels are set black to retain only the image mask.}

\item{min_pixels}{the minimum number of pixels contained in a hexahedra before it can be considered valid (expressed as a percentage)}

\item{smoothing}{the smoothing threshold which eliminates noise in the second derivative of the histogram (higher values gives smoother second derivative)}
}
\description{
Basic image segmentation like connected components labelling, blob extraction and fuzzy c-means
}
\details{
\itemize{
\item \link{image_connect} Connect adjacent pixels with the same pixel intensities to do blob extraction
\item \link{image_split} Splits the image according to pixel intensities
\item \link{image_fuzzycmeans} Fuzzy c-means segmentation of the histogram of color components
}

\link{image_connect} performs blob extraction by scanning the image, pixel-by-pixel from top-left
to bottom-right where regions of adjacent pixels which share the same set of intensity values
get combined.
}
\examples{
# Split an image by color
img <- image_quantize(logo, 4)
layers <- image_split(img)
layers

# This returns the original image
image_flatten(layers)

# From the IM website
objects <- image_convert(demo_image("objects.gif"), colorspace = "Gray")
objects

# Split image in blobs of connected pixel levels
if(magick_config()$version > "6.9.0"){
objects \%>\%
  image_connect(connectivity = 4) \%>\%
  image_split()

# Fuzzy c-means
image_fuzzycmeans(logo)

logo \%>\%
  image_convert(colorspace = "HCL") \%>\%
  image_fuzzycmeans(smoothing = 5)
}
}
\seealso{
Other image: \code{\link{_index_}}, \code{\link{analysis}},
  \code{\link{animation}}, \code{\link{attributes}},
  \code{\link{color}}, \code{\link{composite}},
  \code{\link{device}}, \code{\link{edges}},
  \code{\link{editing}}, \code{\link{effects}},
  \code{\link{fx}}, \code{\link{geometry}},
  \code{\link{morphology}}, \code{\link{ocr}},
  \code{\link{options}}, \code{\link{painting}},
  \code{\link{transform}}, \code{\link{video}}
}
\concept{image}
