% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{analysis}
\alias{analysis}
\alias{image_compare}
\alias{image_fft}
\title{Image Analysis}
\usage{
image_compare(image, reference_image, metric = "")

image_fft(image)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{reference_image}{another image to compare to}

\item{metric}{string with \href{http://www.imagemagick.org/script/command-line-options.php#metric}{metric type}}
}
\description{
Functions for image calculations and analysis. This part of the package needs more work.
}
\details{
For details see \href{https://www.imagemagick.org/Magick++/Image++.html}{Image++}
documentation. Short descriptions:
\itemize{
\item \link{image_compare} calculates a metric by comparing image with a reference image.
\item \link{image_fft} returns Discrete Fourier Transform (DFT) of the image as a
magnitude / phase image pair. I wish I knew what this means.
}

Other analysis functions will be added in future versions!
}
\examples{
logo <- image_read("logo:")
logo2 <- image_blur(logo, 3)
logo3 <- image_oilpaint(logo, 3)
if(magick_config()$version >= "6.8.7"){
  image_compare(logo, logo2, metric = "phash")
  image_compare(logo, logo3, metric = "phash")
}
}
\seealso{
Other image: \code{\link{animation}},
  \code{\link{attributes}}, \code{\link{color}},
  \code{\link{composite}}, \code{\link{device}},
  \code{\link{editing}}, \code{\link{effects}},
  \code{\link{index}}, \code{\link{ocr}},
  \code{\link{painting}}, \code{\link{transform}}
}
