% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.magpie.R
\name{write.magpie}
\alias{write.magpie}
\title{Write MAgPIE-object to file}
\usage{
write.magpie(
  x,
  file_name,
  file_folder = "",
  file_type = NULL,
  append = FALSE,
  comment = NULL,
  comment.char = "*",
  mode = NULL,
  zname = "time",
  ...
)
}
\arguments{
\item{x}{a magclass object. An exception is that formats written via the raster package
(currently "nc", "asc", "grd" and "tif") also accept RasterBrick objects which have
been previously created from a magclass object via as.RasterBrick)}

\item{file_name}{file name including file ending (wildcards are supported).
Optionally also the full path can be specified here (instead of splitting it
to file_name and file_folder)}

\item{file_folder}{folder the file should be written to (alternatively you
can also specify the full path in file_name - wildcards are supported)}

\item{file_type}{Format the data should be stored as. If file_type=NULL
the file ending of the file_name is used as format. See detailed
description for a list of available file types. Please be aware that the
file_name is independent of the file_type you choose here, so no additional
file ending will be added!}

\item{append}{Decides whether an existing file should be overwritten (FALSE)
or the data should be added to it (TRUE). Append = TRUE only works if the
existing data can be combined with the new data using the mbind function}

\item{comment}{Vector of strings: Optional comment giving additional
information about the data. If different to NULL this will overwrite the
content of attr(x,"comment")}

\item{comment.char}{character: a character vector of length one containing a
single character or an empty string. Use "" to turn off the interpretation
of comments altogether.}

\item{mode}{File permissions the file should be written with as 3-digit
number (e.g. "777" means full access for user, group and all, "750" means
full access for user, read access for group and no acess for anybody else).
Set to NULL system defaults will be used. Access codes are identical to the
codes used in unix function chmod.}

\item{zname}{name of the time variable for raster files like nc, asc, grd and tif}

\item{...}{additional arguments passed to specific write functions}
}
\description{
Writes a magpie object to a file. The file type is determined by the filename extension.
The written file can be read again using \code{\link{read.magpie}}.
}
\details{
This function supports writing the following file types:
\itemize{
\item "cs2" is the new standard format for cellular data with or without header
and the first columns (year,regiospatial) or only (regiospatial)
\item "cs2b" is identical to "cs2" except that it will suppress the data name
if it has only 1 element in the data dimension.
\item "csv" is the standard format for regional data with or without header and
the first columns (year,region,cellnumber) or only (region,cellnumber)
\item "cs3" is another csv format which is
specifically designed for multidimensional data for usage in GAMS.
\item "cs4" alternative multidimensional format compatible to GAMS, in contrast
to cs3 it can also handle sparse data
\item "csvr", "cs2r", "cs3r", "cs4r" which are the same formats as the ones
previously explained with the only difference that they have a REMIND
compatible format
\item "cs5" a more generalized version of cs4
\item "rds" is an R-default format for storing R objects
\item "m" (magpie) and "mz" (magpie zipped) are new formats developed to allow
a less storage intensive management of MAgPIE-data. The only difference
between both formats is that .mz is gzipped whereas .m is not compressed. So
.mz needs less memory, whereas .m might have a higher compatibility to other
languages
\item "asc" is the ASCII grid format. It can only be applied for gridded data
and writes one file per year per data column. In the case that more than
one year and data column is supplied several files are written with the
structure filename_year_datacolumn.asc
\item "tif" is the  GEOtiff format for gridded data.
\item "grd" is the native raster format for gridded data.
\item "nc" is the netCDF format for gridded data.
}
}
\note{
The binary MAgPIE formats .m and .mz have the following content/structure
(you only have to care for that if you want to implement
read.magpie/write.magpie functions in other languages): \cr \cr
[ FileFormatVersion | Current file format version number (currently 6) | integer | 2 Byte ] \cr
[ nchar_comment | Number of character bytes of the file comment | integer | 4 Byte ] \cr
[ nbyte_metadata | Number of bytes of the serialized metadata (currently = 0) | integer | 4 Byte ] \cr
[ nchar_sets | Number of characters bytes of all regionnames + 2 delimiter | integer | 2 Byte] \cr
[ nyears | Number of years | integer | 2 Byte ]\cr
[ yearList | All years of the dataset (0, if year is not present) | integer | 2*nyears Byte ] \cr
[ ncells | Number of cells | integer | 4 Byte ]\cr
[ nchar_cell | Number of characters bytes of all regionnames + (nreg-1) for delimiters | integer | 4 Byte ] \cr
[ cells | Cell names saved as cell1\\cell2 (\\n is the delimiter) | character | 1*nchar_cell Byte ] \cr
[ nelem | Total number of data elements | integer | 4 Byte ] \cr
[ nchar_data | Number of char. bytes of all datanames + (ndata - 1) for delimiters | integer | 4 Byte ] \cr
[ datanames | Names saved in the format data1\\ndata2 (\\n as del.) | character | 1*nchar_data Byte ] \cr
[ data | Data of the MAgPIE array in vectorized form | numeric | 4*nelem Byte ] \cr
[ comment | Comment with additional information about the data | character | 1*nchar_comment Byte ] \cr
[ sets | Set names with \\n as delimiter | character | 1*nchar_sets Byte] \cr
[ metadata | serialized metadata information (currently not in use) | bytes | 1*nbyte_metadata Byte] \cr
}
\examples{
pop <- maxample("pop")
path <- tempfile(fileext = ".mz")
write.magpie(pop, path)
pop2 <- read.magpie(path)
}
\seealso{
\code{"\linkS4class{magpie}"},
\code{\link{read.magpie}},\code{\link{mbind}}
}
\author{
Jan Philipp Dietrich, Stephen Bi, Florian Humpenoeder, Pascal Sauer
}
