% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{dt_mutate}
\alias{dt_mutate}
\alias{dt_summarize}
\alias{dt_summarize_all}
\alias{dt_summarise}
\alias{dt_summarise_all}
\alias{dt_select}
\alias{dt_filter}
\alias{dt_arrange}
\title{'dplyr'-like interface for data.table.}
\usage{
dt_mutate(data, ..., by)

dt_summarize(data, ..., by, keyby, fun = NULL)

dt_summarize_all(data, fun, by, keyby)

dt_summarise(data, ..., by, keyby, fun = NULL)

dt_summarise_all(data, fun, by, keyby)

dt_select(data, ...)

dt_filter(data, ...)

dt_arrange(data, ..., na.last = FALSE)
}
\arguments{
\item{data}{data.table/data.frame data.frame will be automatically converted
to data.table. \code{dt_mutate}, \code{dt_mutate_if}, \code{dt_mutate_if}
modify data.table object in-place.}

\item{...}{List of variables or name-value pairs of summary/modifications
functions. The name will be the name of the variable in the result. In the
\code{mutate} function we can use \code{a = b} or \code{a := b} notation.
Advantages of \code{:=} are multiassignment (\code{c("a", "b") := list(1,2)})
and parametric assignment (\code{(a) := 2}).}

\item{by}{unquoted name of grouping variable of list of unquoted names of
grouping variables. For details see \link[data.table]{data.table}}

\item{keyby}{Same as \code{by}, but with an additional \code{setkey()} run on the by
columns of the result, for convenience. It is common practice to use
'keyby=' routinely when you wish the result to be sorted. For details see
\link[data.table]{data.table}.}

\item{fun}{function which will be applied to all variables in
\code{dt_summarize} and \code{dt_summarize_all}.}

\item{na.last}{logical. FALSE by default. If TRUE, missing values in the data
are put last; if FALSE, they are put first.}
}
\description{
Subset of 'dplyr' verbs to work with data.table. Note that there is no
\code{group_by} verb - use \code{by} or \code{keyby} argument when needed.
\itemize{
\item{\code{dt_mutate} }{adds new variables or modify existing variables. If
\code{data} is data.table then it modifies in-place.}
\item{\code{dt_summarize} }{computes summary statistics. Splits the data into
subsets, computes summary statistics for each, and returns the result in the
"data.table" form.}
\item{\code{dt_summarize_all} }{the same as \code{dt_summarize} but work over all non-grouping variables.}
\item{\code{dt_filter} }{Selects rows/cases where conditions are true. Rows
where the condition evaluates to NA are dropped.}
\item{\code{dt_select} }{Selects column/variables from the data set.}
\item{\code{dt_arrange} }{sorts dataset by variable(-s). Use '-' to sort in
descending order. If \code{data} is data.table then it modifies in-place.}
}
}
\examples{
# examples from 'dplyr'
# newly created variables are available immediately
mtcars  \%>\%
    dt_mutate(
        cyl2 = cyl * 2,
        cyl4 = cyl2 * 2
    ) \%>\%
    head()


# you can also use dt_mutate() to remove variables and
# modify existing variables
mtcars \%>\%
    dt_mutate(
        mpg = NULL,
        disp = disp * 0.0163871 # convert to litres
    ) \%>\%
    head()


# window functions are useful for grouped mutates
mtcars \%>\%
    dt_mutate(
        rank = rank(-mpg, ties.method = "min"),
        keyby = cyl) \%>\%
    print()


# You can drop variables by setting them to NULL
mtcars \%>\% dt_mutate(cyl = NULL) \%>\% head()

# A summary applied without by returns a single row
mtcars \%>\%
    dt_summarise(mean = mean(disp), n = .N)

# Usually, you'll want to group first
mtcars \%>\%
    dt_summarise(mean = mean(disp), n = .N, by = cyl)


# Multiple 'by' - variables
mtcars \%>\%
    dt_summarise(cyl_n = .N, by = list(cyl, vs))

# Newly created summaries immediately
# doesn't overwrite existing variables
mtcars \%>\%
    dt_summarise(disp = mean(disp),
                  sd = sd(disp),
                  by = cyl)

# You can group by expressions:
mtcars \%>\%
    dt_summarise_all(mean, by = list(vsam = vs + am))

# filter by condition
mtcars \%>\%
    dt_filter(am==0)

# filter by compound condition
mtcars \%>\%
    dt_filter(am==0,  mpg>mean(mpg))


# select
mtcars \%>\% dt_select(vs:carb, cyl)
mtcars \%>\% dt_select(-am, -cyl)

# sorting
dt_arrange(mtcars, cyl, disp)
dt_arrange(mtcars, -disp)
}
