% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.R
\name{recode}
\alias{recode}
\title{Recode contents of a variable}
\usage{
recode(data, var, old_values, new_values)
}
\arguments{
\item{data}{dataset}

\item{var}{name of a new variable}

\item{old_values}{vector}

\item{new_values}{vector (length of 1 or same with values_old)}
}
\description{
\code{recode} easily manipulates contents of a new variable
of a data.frame
}
\details{
\code{recode}
changes the values of variables including categorical variables
according to the rules specified below.

In case of factor, \code{recode} first converts the vector into character,
recodes and then revert back to factor.

If data is specified, it returns the whole dataframe with recoded variables.

\strong{Sample Inputs for conversion}:

Old.value    to    New.value
}
\section{>>>>}{
c(#, #)     >>>>    c(#, #)

c(#, #)     >>>>       #

#:#      >>>>       #
}

\examples{

## use infert data
data(infert)

## tabulate induced to check values
tab(infert, induced)

## recode induced: 1 and 2 into 1
infert.new <- recode(infert, induced, c(1, 2), 1)

## tabulate to check
tab(infert.new, induced)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
