% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esttab.R
\name{esttab}
\alias{esttab}
\title{Tabulate estimates of regression models for comparison}
\usage{
esttab(...)
}
\arguments{
\item{...}{regression models of \code{mStats}'s functions}
}
\description{
\code{esttab()} produces publication quality tables which can be exported
to \code{.csv} format.
}
\details{
It is an extention to functions like \code{\link{regress}} and
\code{\link{logistic}}. It processes their outputs and generates
a publication quality tabulation for model comparisons.
}
\examples{

## use infert data
data(infert)
codebook(infert)

## running different logistic regression models
m1 <- logistic(infert, case, education, odds_ratio = FALSE)
m2 <- logistic(infert, case, education, age, odds_ratio = FALSE)
m3 <- logistic(infert, case, education, age, parity, odds_ratio = FALSE)
m4 <- logistic(infert, case, education, age, parity, induced, odds_ratio = FALSE)
m5 <- logistic(infert, case, education, age, parity, induced, spontaneous,
               odds_ratio = FALSE)
e <- esttab(m1, m2, m3, m4, m5)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
