% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lua_open.R
\name{lua_open}
\alias{lua_open}
\title{Create a new Lua state}
\usage{
lua_open()
}
\value{
External pointer wrapping the newly created Lua state.
}
\description{
Creates a new, empty Lua state and returns an external pointer wrapping that
state.
}
\details{
All Lua code is executed within a given Lua state. A Lua state is similar to
the global environment in R, in that it is where all variables and functions
are defined. \pkg{luajr} automatically maintains a "default" Lua state, so
most users of \pkg{luajr} will not need to use \code{\link[=lua_open]{lua_open()}}.

However, if for whatever reason you want to maintain multiple different Lua
states at a time, each with their own independent global variables and
functions, \code{\link[=lua_open]{lua_open()}} can be used to create a new Lua state which can then
be passed to \code{\link[=lua]{lua()}}, \code{\link[=lua_func]{lua_func()}} and \code{\link[=lua_shell]{lua_shell()}} via the \code{L} parameter.
These functions will then operate within that Lua state instead of the
default one. The default Lua state can be specified explicitly with
\code{L = NULL}.

Note that there is currently no way (provided by \pkg{luajr}) of saving a
Lua state to disk so that the state can be restarted later. Also, there is
no \code{lua_close} in \pkg{luajr} because Lua states are closed automatically
when they are garbage collected in R.
}
\examples{
L1 <- lua_open()
lua("a = 2")
lua("a = 4", L = L1)
lua("print(a)") # 2
lua("print(a)", L = L1) # 4
}
