% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{getBound}
\alias{getBound}
\title{Get efficacy boundaries for group sequential design}
\usage{
getBound(
  k = NA,
  informationRates = NA,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA,
  userAlphaSpending = NA,
  spendingTime = NA,
  efficacyStopping = NA
)
}
\arguments{
\item{k}{Look number for the current analysis.}

\item{informationRates}{Information rates up to the current look. Must be
increasing and less than or equal to 1.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{spendingTime}{A vector of length \code{k} for the error spending
time at each analysis. Must be increasing and less than or equal to 1.
Defaults to missing, in which case, it is the same as
\code{informationRates}.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is allowed
at each stage. Defaults to true if left unspecified.}
}
\value{
A numeric vector of critical values up to the current look.
}
\description{
Obtains the efficacy stopping boundaries for a group
sequential design.
}
\details{
If \code{typeAlphaSpending} is "OF", "P", or "WT", then the boundaries
will be based on equally spaced looks.
}
\examples{

getBound(k = 2, informationRates = c(0.5,1),
         alpha = 0.025, typeAlphaSpending = "sfOF")

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
