% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_functions.R
\name{gradient}
\alias{gradient}
\title{Computes the gradient of the objective function in X for gradient descent step in ADMM.}
\usage{
gradient(X, Y, projection = default_projection, Theta, gamma, tau)
}
\arguments{
\item{X}{A matrix of Poisson parameters.}

\item{Y}{A matrix of counts (same size as X).}

\item{projection}{A projection function - identifiability constraint - by default centers by rows and columns}

\item{Theta}{A matrix interaction (same size as X).}

\item{gamma}{A matrix (dual variable, same size as X).}

\item{tau}{A number (augmented Lagrangian parameter)}
}
\value{
The gradient of the augmented Lagrangian (with fixed \code{Theta} and \code{gamma}) taken at \code{X}.
}
\description{
Computes the gradient of the objective function in X for gradient descent step in ADMM.
}
\examples{
\dontshow{
X = matrix(rnorm(rep(0, 15)), 5)
Y <- matrix(rpois(length(c(X)), exp(c(X))), 5)
Theta <- default_projection(X)
gamma <- matrix(0, nrow(X), ncol(X))
tau <- 0.1
grad_X <- gradient(X, Y, default_projection, Theta, gamma, tau)
}
}
