% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_tour.R
\name{l_tour}
\alias{l_tour}
\title{Tour in loon}
\usage{
l_tour(
  data,
  scaling = c("data", "variable", "observation", "sphere"),
  by = NULL,
  on,
  as.l_tour = TRUE,
  color = loon::l_getOption("color"),
  tour_path = tourr::grand_tour(),
  group = "color",
  start = NULL,
  slicing = FALSE,
  slicingDistance = NULL,
  numOfTours = 30L,
  interpolation = 40L,
  parent = NULL,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{data}{a data frame with numerical data only}

\item{scaling}{one of 'variable', 'data', 'observation', 'sphere', or 'none' to specify how the data is scaled.
See Details}

\item{by}{loon plot can be separated by some variables into multiple panels.
This argument can take a \code{\link{formula}},
\code{n} dimensional state names (see \code{\link[loon]{l_nDimStateNames}})
an \code{n}-dimensional \code{vector} and \code{data.frame} or
a \code{list} of same lengths \code{n} as input.}

\item{on}{if the \code{x} or \code{by} is a formula,
an optional data frame containing the variables in the \code{x} or \code{by}.
If the variables are not found in data, they are taken from environment,
typically the environment from which the function is called.}

\item{as.l_tour}{return a \code{l_tour} object; see details}

\item{color}{vector with line colors. Default is given by \code{\link[loon]{l_getOption}("color")}.}

\item{tour_path}{tour path generator, defaults to 2d grand tour}

\item{group}{only used for layers. As we scroll the bar, the layers are re-calculated.
This argument is used to specify which state is used to set groups (i.e. "color", "linewidth", etc).}

\item{start}{projection to start at, if not specified, uses default
associated with tour path}

\item{slicing}{whether to show a sliced scatter plot}

\item{slicingDistance}{the slicing distance that if the distance between
points and the projected plane is less than this distance, points will be
preserved; else points will be invisible. The default is \code{NULL} and a suggested
value will be given. See details}

\item{numOfTours}{the number of tours}

\item{interpolation}{the steps between two serial projections. The larger the value is,
the smoother the transitions would be.}

\item{parent}{a valid Tk parent widget path. When the parent widget is
specified (i.e. not \code{NULL}) then the plot widget needs to be placed using
some geometry manager like \code{\link{tkpack}} or \code{\link{tkplace}} in
order to be displayed. See the examples below.}

\item{envir}{the \code{\link{environment}} to use.}

\item{...}{named arguments to modify the serialaxes states or layouts, see details.}
}
\value{
an \code{l_tour} or an \code{l_tour_compound} object that
one can query the \code{loon} states and a matrix projection vectors
}
\description{
An interactive tour in loon
}
\details{
\itemize{
\item {tour_path is a tour generator; available tours are \code{\link{grand_tour}},
\code{\link{dependence_tour}}, \code{\link{frozen_tour}}, \code{\link{guided_tour}},
\code{\link{planned_tour}}, and etc}
\item {Argument \code{as.l_tour}
\itemize{
\item{If set to \code{TRUE}, the function returns an \code{l_tour} (or an \code{l_tour_compound}) object. Essentially, this object is a list with the first element being a \code{loon} (Tcl) widget and the second element a matrix of projection vectors. The advantage of this setup is that the matrix of projection vectors can be easily accessed using the \code{`[`} function (or the \code{l_cget} function). However, a limitation is that it does not constitute a valid \code{loon} (Tcl) widget-calling \code{l_isLoonWidget} would return \code{FALSE}. Consequently, many of loon's functionalities remain inaccessible.}
\item{If set to \code{FALSE}, the function returns either a \code{loon} (Tcl) widget (where calling \code{l_isLoonWidget} would return \code{TRUE}) or an \code{l_compound} object. In this case, the matrix of projection vectors is not directly accessible from it. However, the \code{l_getProjection} function can be used to retrieve an estimated matrix of projection vectors.}
}
}
\item {The \code{scaling} state defines how the data is scaled. The axes display 0 at one end and 1 at the other. For the following explanation assume that the data is in a n x p dimensional matrix. The scaling options are then
\tabular{ll}{
variable \tab per column scaling\cr
observation \tab per row scaling\cr
data \tab whole matrix scaling\cr
sphere \tab transforming variables to principal components}}
\item {The default \code{slidingDistance} is suggested by Laa, U., Cook, D., & Valencia, G. (2020).
First, find the maximum Euclidean distance of each observation (centralized), say \code{maxD}.
Then, compute the "relative volume" that \code{vRel} = (\code{maxD}^(d - 2))/10, where \code{d}
is the dimension of this data set. In the end, the suggested \code{slidingDistance}
is given by \code{vRel}^(1/(d - 2))
}
}
}
\examples{
if(interactive() && requireNamespace('tourr')) {
  # 2D projection
  fl <- tourr::flea[, 1:6]
  # different scaling will give very different projections
  # in this dataset, scaling 'variable' will give the best separation
  p <- l_tour(fl, scaling = 'variable',
              color = tourr::flea$species)
  l0 <- l_layer_hull(p, group = p["color"],
                     color = "red", linewidth = 4)
  l1 <- l_layer_density2d(p)
  # a `l_tour` object
  class(p)

  # query the matrix of projection vectors
  proj <- p['projection'] # or `l_getProjection(p)`
  # suppose the scaling is still 'observation'
  new_xy <- as.matrix(
    loon::l_getScaledData(data = fl,
                          scaling = 'observation')) \%*\%
    proj
  plot(new_xy, xlab = "V1", ylab = "V2",
       col = loon::hex12tohex6(p['color']))

  # A higher dimension projection
  # turn the `tour` to 4 dimensional space
  s <- l_tour(fl, color = tourr::flea$species,
              scaling = "observation",
              tour_path = tourr::grand_tour(4L))

  # set `as.l_tour` FALSE
  p <- l_tour(fl, scaling = 'observation',
              color = tourr::flea$species)
  class(p)
  ## ERROR
  ## p["projection"]

  # query the estimated matrix of projection vectors
  l_getProjection(p)

  ##### facet by region
  olive <- tourr::olive
  p <- with(olive, l_tour(olive[, -c(1, 2)],
                          by = region,
                          color = area))
}
}
\seealso{
\code{\link{l_getProjection}}
}
