% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_log_lik.R
\name{extract_log_lik}
\alias{extract_log_lik}
\title{Extract pointwise log-likelihood matrix from a Stan model}
\usage{
extract_log_lik(stanfit, parameter_name = "log_lik")
}
\arguments{
\item{stanfit}{A \code{stanfit} object (\pkg{rstan} package).}

\item{parameter_name}{A character string naming the parameter (or generated
quantity) in the Stan model corresponding to the log-likelihood.}
}
\value{
An \eqn{S} by \eqn{N} matrix of (post-warmup) extracted draws, where
  \eqn{S} is the size of the posterior sample and \eqn{N} is the number of
  data points.
}
\description{
Convenience function for extracting the pointwise log-likelihood from a
fitted Stan model.
}
\details{
Stan does not automatically compute and store the log-likelihood. It
  is up to the user to incorporate it into the Stan program if it is to be
  extracted after fitting the model. In a Stan model, the pointwise log
  likelihood can be coded as a vector in the transformed parameters block
  (and then summed up in the model block) or it can be coded entirely in the
  generated quantities block. We recommend using the generated quantities
  block so that the computations are carried out only once per iteration
  rather than once per HMC leapfrog step.

  For example, the following is the \code{generated quantities} block for
  computing and saving the log-likelihood for a linear regression model with
  \code{N} data points, outcome \code{y}, predictor matrix \code{X},
  coefficients \code{beta}, and standard deviation \code{sigma}:

 \code{vector[N] log_lik;}

 \code{for (n in 1:N) log_lik[n] = normal_lpdf(y[n] | X[n] * beta, sigma);}
}
\references{
Stan Development Team (2016). The Stan C++ Library, Version 2.10.0.
\url{http://mc-stan.org/documentation/}

Stan Development Team (2016). RStan: the R interface to Stan, Version 2.10.1.
\url{http://mc-stan.org/interfaces/rstan.html}
}
