% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logisticSVD.R
\name{cv.lsvd}
\alias{cv.lsvd}
\title{CV for logistic SVD}
\usage{
cv.lsvd(x, ks, folds = 5, quiet = TRUE, ...)
}
\arguments{
\item{x}{matrix with all binary entries}

\item{ks}{the different dimensions \code{k} to try}

\item{folds}{if \code{folds} is a scalar, then it is the number of folds. If
it is a vector, it should be the same length as the number of rows in \code{x}}

\item{quiet}{logical; whether the function should display progress}

\item{...}{Additional arguments passed to logisticSVD}
}
\value{
A matrix of the CV negative log likelihood with \code{k} in rows
}
\description{
Run cross validation on dimension for logistic SVD
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

\dontrun{
negloglikes = cv.lsvd(mat, ks = 1:9)
plot(negloglikes)
}
}

