% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qdis.lm.R
\name{plot_qdis.lm}
\alias{plot_qdis.lm}
\title{Plot of the distribution of quantiles for an object of class 'lm'}
\usage{
\method{plot_qdis}{lm}(object_1, object_2 = NULL, ...)
}
\arguments{
\item{object_1}{Object of class 'lm'}

\item{object_2}{Object of class 'lm' or class 'lmvar'}

\item{...}{for compatibility with \code{\link{plot_qdis}} generic.}
}
\description{
Function produces plot of the distribution of quantiles for an object of
class 'lm' and, optionally, for another object of class 'lm' or 'lmvar'.
}
\details{
If \code{object_2} is specified, a plot for \code{object_1} and one for \code{object_2} will be
combined in the same plot.

All inputs of class 'lm' must contain the response vector \eqn{y}. I.e., one must run \code{\link[stats]{lm}}
with argument \code{y = TRUE}.
}
\examples{
if(interactive()){

library(lmvar)

# create a linear model using the 'iris' data set
fit_lm = lm(Petal.Length ~ Species, data = iris, y = TRUE)

plot_qdis(fit_lm)

# compare 'lm' with 'lmvar' fit
X = model.matrix(~ Species - 1, data = iris)
fit_lmvar = lmvar(iris$Petal.Length, X, X)

plot_qdis(fit_lm, fit_lmvar)

# check whether inclustion of petal in model improves distribution of quantiles
fit_lm_width = lm(Petal.Length ~ Species + Petal.Width, data = iris, y = TRUE)

plot_qdis(fit_lm, fit_lm_width)

}
}
\seealso{
\code{\link{plot_qdis}}
}
