% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.glmmlasso.R
\name{cv.glmmLasso}
\alias{cv.glmmLasso}
\title{Cross Validation for glmmLasso package}
\usage{
cv.glmmLasso(dat, form.fixed = NULL, form.rnd = NULL, lambda = seq(500, 0,
  by = -5), family = stats::gaussian(link = "identity"))
}
\arguments{
\item{dat}{data.frame, containing y,X,Z and subject variables}

\item{form.fixed}{formaula, fixed param formula, Default: NULL}

\item{form.rnd}{list, named list containing random effect formula, Default: NULL}

\item{lambda}{numeric, vector containing lasso penalty levels, Default: seq(500, 0, by = -5)}

\item{family}{family, family function that defines the distribution link of the glmm, Default: gaussian(link = "identity")}
}
\value{
list of a fitted glmmLasso object and the cv BIC path
}
\description{
Cross Validation for glmmLasso package as shown in example xxx
}
\examples{
\dontrun{cv.glmmLasso(initialize_example(seed=1))}
}
\references{
A. Groll and G. Tutz. Variable selection for generalized linear mixed models by L1-penalized estimation. 
 Statistics and Computing, pages 1–18, 2014.
 
 \href{https://raw.githubusercontent.com/cran/glmmLasso/master/demo/glmmLasso-soccer.r}{cv function is the generalized form of last example glmmLasso package demo file}
}
\seealso{
\code{\link[glmmLasso]{glmmLasso}}
}
