### $Id: Orthodont.q,v 1.4 1999/01/15 15:50:28 bates Exp $
### An orthodontic measurement on several children over time
### Pothoff and Roy (1964), Biometrika, 51, 313-326
"Orthodont" <-
  structure(list
  (distance = c(26, 25, 29, 31, 21.5, 22.5, 23, 26.5, 
     23, 22.5, 24, 27.5, 25.5, 27.5, 26.5, 27, 20, 23.5, 22.5, 26, 
     24.5, 25.5, 27, 28.5, 22, 22, 24.5, 26.5, 24, 21.5, 24.5, 25.5, 
     23, 20.5, 31, 26, 27.5, 28, 31, 31.5, 23, 23, 23.5, 25, 21.5, 
     23.5, 24, 28, 17, 24.5, 26, 29.5, 22.5, 25.5, 25.5, 26, 23, 24.5, 
     26, 30, 22, 21.5, 23.5, 25, 21, 20, 21.5, 23, 21, 21.5, 24, 25.5, 
     20.5, 24, 24.5, 26, 23.5, 24.5, 25, 26.5, 21.5, 23, 22.5, 23.5, 
     20, 21, 21, 22.5, 21.5, 22.5, 23, 25, 23, 23, 23.5, 24, 20, 21, 
     22, 21.5, 16.5, 19, 19, 19.5, 24.5, 25, 28, 28),
   age = c(8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14,
     8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8,
     10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10,
     12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12,
     14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14,
     8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8, 10, 12, 14, 8,
     10, 12, 14, 8, 10, 12, 14),
   Subject = structure(ordered(c(15, 15, 15, 15, 
     3, 3, 3, 3, 7, 7, 7, 7, 14, 14, 14, 14, 2, 2, 2, 2, 13, 13, 13, 
     13, 5, 5, 5, 5, 6, 6, 6, 6, 11, 11, 11, 11, 16, 16, 16, 16, 4, 
     4, 4, 4, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 12, 12, 12, 
     12, 1, 1, 1, 1, 20, 20, 20, 20, 23, 23, 23, 23, 25, 25, 25, 25, 
     26, 26, 26, 26, 21, 21, 21, 21, 19, 19, 19, 19, 22, 22, 22, 22, 
     24, 24, 24, 24, 18, 18, 18, 18, 17, 17, 17, 17, 27, 27, 27, 27
     ), levels=1:27),
     class = c("ordered", "factor"),
     .Label = c("M16", "M05", "M02", "M11", "M07", "M08", "M03",
       "M12", "M13", "M14", "M09", "M15", "M06", "M04", "M01", "M10",
       "F10", "F09", "F06", "F01", "F05", "F07", "F02", "F08", "F03",
       "F04", "F11")),
   Sex = structure(factor(c(1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
     2, 2), levels=1:2), class = "factor",
     .Label = c("Male", "Female"))),
row.names = as.character(1:108), outer = ~ Sex,
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = distance ~ age | Subject,
labels = list(x = "Age",
  y = "Distance from pituitary to pterygomaxillary fissure"),
units = list(x = "(yr)", y = "(mm)"))
