% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\name{forc,Forecast-method}
\alias{forc,Forecast-method}
\title{Get the forecast slot of a Forecast object}
\usage{
\S4method{forc}{Forecast}(Forecast)
}
\arguments{
\item{Forecast}{Forecast object.}
}
\value{
Vector of forecast values stored in the \link{Forecast} object.
}
\description{
\code{forc} takes a \code{\link{Forecast}} object and gets the
forecast vector of the forecast.
}
\examples{
my_forecast <- Forecast(
   origin   = c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31"),
   future   = c("2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31"),
   forecast = c(4.21, 4.27, 5.32, 5.11),
   realized = c(4.40, 4.45, 4.87, 4.77),
   h_ahead  = 4L
)

forc(my_forecast)

}
