% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{getCover}
\alias{getCover}
\title{Get Cover of partitioned SVM}
\usage{
getCover(model, task = 1)
}
\arguments{
\item{model}{the model}

\item{task}{the task between 1 and number of tasks}
}
\value{
the indices of the samples in the training data set that were used as Voronoi partition centers.
}
\description{
If you use \code{voronoi=3} or \code{voronoi=4} this retrieves the voronoi centers that have been found.
}
\note{
This is not tested thoroughly so use in production is at your own risk.
}
\examples{
\dontrun{
banana <- liquidData('banana-mc')
model <- mcSVM(Y~.,banana$train, voronoi=c(4,500),d=1)
# task 4 is predicting 2 vs 3
cover <- getCover(model,task=4)
centers <- cover$samples
# we are considering task 4 and hence only show labels 2 and 3:
bananaSub <- banana$train[banana$train$Y \%in\% c(2,3),]
plot(bananaSub[,-1],col=bananaSub$Y)
points(centers,pch='x',cex=2)

if(require(deldir)){
  voronoi <- deldir::deldir(centers$X1,centers$X2,rw=c(range(bananaSub$X1),range(bananaSub$X2)))
  plot(voronoi,wlines="tess",add=TRUE, lty=1)
  text(centers$X1,centers$X2,1:nrow(centers),pos=1)
}

# let us calculate for every sample in this task which cell it belongs to
distances <- as.matrix(dist(model$train_data))
cells <- apply(distances[model$train_labels \%in\% c(2,3),cover$indices],1,which.min)
# and you can check that the cell sizes are as reported in the training phase for task 4
table(cells)
}
}

