% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_identical_linter.R
\name{expect_identical_linter}
\alias{expect_identical_linter}
\title{Require usage of \code{expect_identical(x, y)} where appropriate}
\usage{
expect_identical_linter()
}
\description{
This linter enforces the usage of \code{\link[testthat:equality-expectations]{testthat::expect_identical()}} as the
default expectation for comparisons in a testthat suite. \code{expect_true(identical(x, y))}
is an equivalent but unadvised method of the same test. Further,
\code{\link[testthat:equality-expectations]{testthat::expect_equal()}} should only be used when \code{expect_identical()}
is inappropriate, i.e., when \code{x} and \code{y} need only be \emph{numerically
equivalent} instead of fully identical (in which case, provide the
\verb{tolerance=} argument to \code{expect_equal()} explicitly). This also applies
when it's inconvenient to check full equality (e.g., names can be ignored,
in which case \code{ignore_attr = "names"} should be supplied to
\code{expect_equal()} (or, for 2nd edition, \code{check.attributes = FALSE}).
}
\section{Exceptions}{


The linter allows \code{expect_equal()} in three circumstances:
\enumerate{
\item A named argument is set (e.g. \code{ignore_attr} or \code{tolerance})
\item Comparison is made to an explicit decimal, e.g.
\code{expect_equal(x, 1.0)} (implicitly setting \code{tolerance})
\item \code{...} is passed (wrapper functions which might set
arguments such as \code{ignore_attr} or \code{tolerance})
}
}

\examples{
# will produce lints
lint(
  text = "expect_equal(x, y)",
  linters = expect_identical_linter()
)

lint(
  text = "expect_true(identical(x, y))",
  linters = expect_identical_linter()
)

# okay
lint(
  text = "expect_identical(x, y)",
  linters = expect_identical_linter()
)

lint(
  text = "expect_equal(x, y, check.attributes = FALSE)",
  linters = expect_identical_linter()
)

lint(
  text = "expect_equal(x, y, tolerance = 1e-6)",
  linters = expect_identical_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=package_development_linters]{package_development}
}
