% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echelon.R
\name{echelon}
\alias{echelon}
\title{Reduced row echelon form}
\usage{
echelon(A, b, neq = nrow(A), nleq = 0, eps = 1e-08)
}
\arguments{
\item{A}{\code{[numeric]} matrix}

\item{b}{\code{[numeric]} vector}

\item{neq}{\code{[numeric]} The first \code{neq} rows of \code{A}, \code{b} are treated as equations.}

\item{nleq}{[\code{numeric}] The \code{nleq} rows after \code{neq} are treated as
inequations of the form \code{a.x<=b}. All remaining rows are treated as strict inequations
of the form \code{a.x<b}.}

\item{eps}{\code{[numeric]} Values of magnitude less than \code{eps} are considered zero (for the purpose of handling
machine rounding errors).}
}
\value{
A list with the following components:
\itemize{
  \item{\code{A}: the \code{A} matrix with equalities transformed to RRE form.}
  \item{\code{b}: the constant vector corresponding to \code{A}}
  \item{\code{neq}: the number of equalities in the resulting system.}
  \item{\code{nleq}}: the number of inequalities of the form \code{a.x <= b}. This will only
  be passed to the output.
}
}
\description{
Transform the equalities in a system of linear (in)equations or Reduced Row Echelon form (RRE)
}
\section{Details}{


The parameters \code{A}, \code{b} and \code{neq} describe a system of the form \code{Ax<=b}, where
the first \code{neq} rows are equalities. The equalities are transformed to RRE form.


A system of equations is in \href{https://en.wikipedia.org/wiki/Row_echelon_form}{reduced row echelon} form when
\itemize{
\item{All zero rows are below the nonzero rows}
\item{For every row, the leading coefficient (first nonzero from the left) is always right of the leading coefficient of the row above it.}
\item{The leading coefficient equals 1, and is the only nonzero coefficient in its column.}
}
}
\examples{
echelon(
 A = matrix(c(
    1,3,1,
    2,7,3,
    1,5,3,
    1,2,0), byrow=TRUE, nrow=4)
 , b = c(4,-9,1,8)
 , neq=4
)


}

