% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registry.R
\name{setup_component_observers}
\alias{setup_component_observers}
\title{Set up observers for different component types}
\usage{
setup_component_observers(
  component_id,
  type,
  session,
  components,
  shared_state,
  on_selection_change,
  registry = NULL
)
}
\arguments{
\item{component_id}{Character string. Unique identifier for the component.}

\item{type}{Character string. The type of component to set up observers for.
Currently supports "leaflet" and "datatable".}

\item{session}{'shiny' session object. The current 'shiny' session.}

\item{components}{List. Collection of all components in the application.}

\item{shared_state}{Reactive values object. Shared state across components.}

\item{on_selection_change}{Function. Callback function to execute when
selection changes occur.}

\item{registry}{Optional. Registry object for component management. Default is NULL.}
}
\value{
List of observer objects created for the specified component type. Throws Error if an unsupported component type is provided.
}
\description{
\code{setup_component_observers} is an internal function that creates and configures observers for different types of
interactive components based on the specified component type. It acts as a
dispatcher that calls the appropriate setup function for each supported component.
}
\keyword{internal}
