% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPutils.R
\name{ggplot.lineqGP}
\alias{ggplot.lineqGP}
\title{GGPlot for the \code{"lineqGP"} S3 Class}
\usage{
\method{ggplot}{lineqGP}(data, mapping, ytest = NULL, probs = c(0.05,
  0.95), bounds = NULL, addlines = TRUE, nblines = 5,
  fillbackground = TRUE, alpha.qtls = 0.4, xlab = "", ylab = "",
  main = "", xlim = NULL, ylim = NULL, lwd = 1, cex = 1.5, ...)
}
\arguments{
\item{data}{an object with \code{"lineqGP"} S3 class.}

\item{mapping}{not used.}

\item{ytest}{the values of the test observations. \code{If !is.null(ytest)}, ytest is drawn.}

\item{probs}{the values of the confidence intervals evaluated at probs.}

\item{bounds}{the values of the bounds of a constrained model. If \code{!is.null(bounds)}, bounds are drawn.}

\item{addlines}{an optional Logical. If \code{TRUE}, some samples are drawn.}

\item{nblines}{if \code{addlines}. The number of samples to be drawn.}

\item{fillbackground}{an optional logical. If \code{TRUE}, fill gray background.}

\item{alpha.qtls}{a number indicating the transparency of the quantiles.}

\item{xlab}{a character string corresponding to the title for the x axis.}

\item{ylab}{a character string corresponding to the title for the y axis.}

\item{main}{a character string corresponding to the overall title for the plot.}

\item{xlim}{the limit values for the x axis.}

\item{ylim}{the limit values for the y axis.}

\item{lwd}{a number indicating the line width.}

\item{cex}{a number indicating the amount by which plotting text and symbols should be scaled.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
GGPlot with the \code{"lineqGP"} model.
}
\description{
GGPlot for the \code{"lineqGP"} S3 class.
}
\seealso{
\code{\link{ggplot}}, \code{\link{plot.lineqGP}}
}
\author{
A. F. Lopez-Lopera.
}
