### R code from vignette source 'likert-xtable.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(digits=3)
options(width=80)
options(continue="  ")


###################################################
### code chunk number 2: likert-xtable.Rnw:24-44
###################################################
require(likert)
require(reshape)
data(pisaitems)

##### Item 24: Reading Attitudes
items24 <- pisaitems[,substr(names(pisaitems), 1,5) == 'ST24Q']
items24 <- rename(items24, c(
			ST24Q01="I read only if I have to.",
			ST24Q02="Reading is one of my favorite hobbies.",
			ST24Q03="I like talking about books with other people.",
			ST24Q04="I find it hard to finish books.",
			ST24Q05="I feel happy if I receive a book as a present.",
			ST24Q06="For me, reading is a waste of time.",
			ST24Q07="I enjoy going to a bookstore or a library.",
			ST24Q08="I read only to get information that I need.",
			ST24Q09="I cannot sit still and read for more than a few minutes.",
			ST24Q10="I like to express my opinions about books I have read.",
			ST24Q11="I like to exchange books with my friends."))
l24 = likert(items24)
l24g <- likert(items24, grouping=pisaitems$CNT)


###################################################
### code chunk number 3: likert-xtable.Rnw:49-50
###################################################
xtable(l24)


###################################################
### code chunk number 4: likert-xtable.Rnw:53-54
###################################################
xtable(l24g)


