% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_intraday.R
\name{get_hr_zones}
\alias{get_hr_zones}
\title{Calculate Heart Rate Zones.}
\usage{
get_hr_zones(person)
}
\arguments{
\item{person}{An instance of the Person class}
}
\value{
Returns a list with 3 vectors of length 2: peak, cardio, and fat_burn
}
\description{
Heart Rate Zones are calculated on the basis of age.  The 
    estimated maximum heart rate is calculated as 220 - the age of the user.  
    The peak heart rate zone is 85% greater than maximum heart rate, the 
    cardio heart rate zone is between 70 and 84% of maximum, and the fat burn
     heart rate zone is between 50 and 69% of maximum.
}
\examples{
data(EX)
get_hr_zones(EX)
}
\seealso{
\url{https://help.fitbit.com/articles/en_US/Help_article/1565#zones}
}
