% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_options.R
\name{engine_options}
\alias{engine_options}
\alias{opt_chunk_buffer}
\alias{opt_chunk_buffer<-}
\alias{opt_chunk_size}
\alias{opt_chunk_size<-}
\alias{opt_chunk_alignment}
\alias{opt_chunk_alignment<-}
\alias{opt_restart<-}
\alias{opt_progress}
\alias{opt_progress<-}
\alias{opt_stop_early}
\alias{opt_stop_early<-}
\alias{opt_wall_to_wall}
\alias{opt_wall_to_wall<-}
\alias{opt_independent_files}
\alias{opt_independent_files<-}
\alias{opt_output_files}
\alias{opt_output_files<-}
\alias{opt_laz_compression}
\alias{opt_laz_compression<-}
\alias{opt_merge}
\alias{opt_merge<-}
\alias{opt_select}
\alias{opt_select<-}
\alias{opt_filter}
\alias{opt_filter<-}
\title{Get or set LAScatalog processing engine options}
\usage{
opt_chunk_buffer(ctg)

opt_chunk_buffer(ctg) <- value

opt_chunk_size(ctg)

opt_chunk_size(ctg) <- value

opt_chunk_alignment(ctg)

opt_chunk_alignment(ctg) <- value

opt_restart(ctg) <- value

opt_progress(ctg)

opt_progress(ctg) <- value

opt_stop_early(ctg)

opt_stop_early(ctg) <- value

opt_wall_to_wall(ctg)

opt_wall_to_wall(ctg) <- value

opt_independent_files(ctg)

opt_independent_files(ctg) <- value

opt_output_files(ctg)

opt_output_files(ctg) <- value

opt_laz_compression(ctg)

opt_laz_compression(ctg) <- value

opt_merge(ctg)

opt_merge(ctg) <- value

opt_select(ctg)

opt_select(ctg) <- value

opt_filter(ctg)

opt_filter(ctg) <- value
}
\arguments{
\item{ctg}{An object of class \link[=LAScatalog-class]{LAScatalog}}

\item{value}{An appropriate value depending on the expected input.}
}
\description{
The names of the options and their roles are documented in \link[=LAScatalog-class]{LAScatalog}.
The options are used by all the functions that support a \code{LAScatalog} as input. Most options are
easy to understand and to link to the documentation of \link[=LAScatalog-class]{LAScatalog} but some
need more details. See section 'Details'.
}
\details{
\itemize{
\item \strong{opt_restart()} automatically sets the chunk option named "drop" in such a way that
the engine will restart at a given chunk and skip all previous chunks. Useful for restarting after a crash.
\item \strong{opt_independent_file()} automatically sets the chunk size, chunk buffer and wall-to-wall options
to process files that are not spatially related to each other, such as plot inventories.
\item \strong{opt_laz_compression()} automatically modifies the drivers to write LAZ files instead of LAS files.
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
ctg = readLAScatalog(LASfile)

plot(ctg, chunk_pattern = TRUE)

opt_chunk_size(ctg) <- 150
plot(ctg, chunk_pattern = TRUE)

opt_chunk_buffer(ctg) <- 10
plot(ctg, chunk_pattern = TRUE)

opt_chunk_alignment(ctg) <- c(270,250)
plot(ctg, chunk_pattern = TRUE)

summary(ctg)

opt_output_files(ctg) <- "/path/to/folder/templated_filename_{XBOTTOM}_{ID}"
summary(ctg)
}
\seealso{
Other LAScatalog processing engine: 
\code{\link{engine}}
}
\concept{LAScatalog processing engine}
