% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_shapes.R
\name{segment_shapes}
\alias{segment_shapes}
\alias{point_eigenvalues}
\title{Eigenvalues-based features at the point level}
\usage{
segment_shapes(las, algorithm, attribute = "Shape", filter = NULL)

point_eigenvalues(las, k, r, xyz = FALSE, metrics = FALSE, filter = NULL)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{algorithm}{An algorithm for shape detection. lidR has: \link{shp_plane}, \link{shp_hplane}
and \link{shp_line}.}

\item{attribute}{character. The name of the new column to add into the LAS object.}

\item{filter}{formula of logical predicates. Enables the function to run only on points of interest
in an optimized way. See the examples.}

\item{k, r}{integer and numeric respectively for k-nearest neighbours and radius of the neighborhood
sphere. If k is given and r is missing, computes with the knn, if r is given and k is missing
computes with a sphere neighbourhood, if k and r are given computes with the knn and a limit on the
search distance.}

\item{xyz}{logical. Returns the XYZ coordinates of each points instead of IDs.}

\item{metrics}{logical. Compute additional metrics such as curvature, linearity, planarity based
on the eigenvalues.}
}
\value{
\describe{
\item{\strong{segment_shape}}{A LAS object with a new column named after the argument \code{attribute} that indicates
those points that are part of a neighborhood that is approximately of the shape searched (TRUE)
or not (FALSE).}
\item{\strong{point_eigenvalues}}{A data.frame like \link{point_metrics}}
}
}
\description{
Functions that compute, for each point, the eigenvalues of the covariance matrix of the neighbouring
points. The eigenvalues are later used either to segment linear/planar points or to compute derived
metrics (see Details).
}
\details{
All the functions documented here can be reproduced with \link{point_metrics}. However,
\link{point_metrics} is a versatile and multipurpose function that is not as fast as is possible because
it calls user-defined R code and that implies computational overheads. These functions are parallelized
plain C++ versions of tools users can build with \code{point_metrics} and are consequently 10-times faster.
\describe{
\item{\strong{segment_shape}}{The points that meet a given criterion based on the eigenvalue are labelled as
approximately coplanar/colinear or any other shape supported.}
\item{\strong{point_eigenvalues}}{Computes the eigenvalues of the covariance matrix and computes associated
metrics following Lucas et al, 2019 (see references). It is equivalent to \code{point_metrics(las, .stdshapemetrics)}
but much faster}
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile, filter = "-keep_random_fraction 0.5")

# Use the eigenvalues to estimate if points are part of a local plan
las <- segment_shapes(las, shp_plane(k = 15), "Coplanar")
#plot(las, color = "Coplanar")

# Computes the eigenvalue of each point
M <- point_eigenvalues(las, k = 15)
M

\dontrun{

# Drop ground point at runtime
las <- segment_shapes(las, shp_plane(k = 15), "Coplanar", filter = ~Classification != 2L)
#plot(las, color = "Coplanar")
}

}
\references{
Lucas, C., Bouten, W., Koma, Z., Kissling, W. D., & Seijmonsbergen, A. C. (2019).
Identification of Linear Vegetation Elements in a Rural Landscape Using LiDAR Point Clouds.
Remote Sensing, 11(3), 292.
}
