/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/Simulation.h>
#include <so/private/Simulation.h>

so_Simulation *so_Simulation_new()
{
	so_Simulation *object = calloc(sizeof(so_Simulation), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_Simulation *so_Simulation_copy(so_Simulation *self)
{
	so_Simulation *dest = so_Simulation_new();
	if (dest) {
		if (self->num_SimulationBlock) {
			dest->SimulationBlock = calloc(self->num_SimulationBlock * sizeof(so_SimulationBlock *), 1);
			if (!dest->SimulationBlock) {
				so_Simulation_free(dest);
				return NULL;
			}
			dest->num_SimulationBlock = self->num_SimulationBlock;
			for (int i = 0; i < self->num_SimulationBlock; i++) {
				dest->SimulationBlock[i] = so_SimulationBlock_copy(self->SimulationBlock[i]);
				if (!dest->SimulationBlock[i]) {
					so_Simulation_free(dest);
					return NULL;
				}
			}
		}
	}

	return dest;
}

void so_Simulation_free(so_Simulation *self)
{
	if (self) {
		for(int i = 0; i < self->num_SimulationBlock; i++) {
			so_SimulationBlock_unref(self->SimulationBlock[i]);
		}
		free(self->SimulationBlock);
		free(self);
	}
}

void so_Simulation_ref(so_Simulation *self)
{
	self->reference_count++;
}

void so_Simulation_unref(so_Simulation *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_Simulation_free(self);
		}
	}
}

so_SimulationBlock *so_Simulation_get_SimulationBlock(so_Simulation *self, int number)
{
	return self->SimulationBlock[number];
}

int so_Simulation_get_number_of_SimulationBlock(so_Simulation *self)
{
	return self->num_SimulationBlock;
}

so_SimulationBlock *so_Simulation_create_SimulationBlock(so_Simulation *self)
{
	so_SimulationBlock *obj = so_SimulationBlock_new();
	if (obj) {
		so_SimulationBlock **newblock = realloc(self->SimulationBlock, (self->num_SimulationBlock + 1) * sizeof(so_SimulationBlock *));
		if (newblock) {
			self->SimulationBlock = newblock;
			self->SimulationBlock[self->num_SimulationBlock] = obj;
			self->num_SimulationBlock++;
		} else {
			so_SimulationBlock_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

int so_Simulation_add_SimulationBlock(so_Simulation *self, so_SimulationBlock *child)
{
	so_SimulationBlock **new_array = realloc(self->SimulationBlock, (self->num_SimulationBlock + 1) * sizeof(so_SimulationBlock *));
	if (!new_array) {
		return 1;
	}
	self->SimulationBlock = new_array;
	self->SimulationBlock[self->num_SimulationBlock] = child;
	self->num_SimulationBlock++;
	return 0;
}

int so_Simulation_remove_SimulationBlock(so_Simulation *self, int index)
{
	int size = self->num_SimulationBlock;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->SimulationBlock);
		self->SimulationBlock = NULL;
		return 0;
	}
	so_SimulationBlock *final = self->SimulationBlock[size - 1];
	so_SimulationBlock *remove = self->SimulationBlock[index];
	so_SimulationBlock **new_array = realloc(self->SimulationBlock, (self->num_SimulationBlock - 1) * sizeof(so_SimulationBlock *));
	if (!new_array) {
		return 1;
	}
	self->num_SimulationBlock--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->SimulationBlock[i] = self->SimulationBlock[i + 1];
	}
	self->SimulationBlock[size - 2] = final;
	so_SimulationBlock_unref(remove);
	return 0;
}

int so_Simulation_xml(so_Simulation *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->SimulationBlock) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "Simulation");
		if (rc < 0) return 1;
		if (self->SimulationBlock) {
			for (int i = 0; i < self->num_SimulationBlock; i++) {
				rc = so_SimulationBlock_xml(self->SimulationBlock[i], writer);
				if (rc != 0) return 1;
			}
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_Simulation_start_element(so_Simulation *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_SimulationBlock) {
		int fail = so_SimulationBlock_start_element(self->SimulationBlock[self->num_SimulationBlock - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "SimulationBlock") == 0) {
		so_SimulationBlock *SimulationBlock = so_SimulationBlock_new();
		if (!SimulationBlock) {
			return 1;
		}
		int fail = so_SimulationBlock_init_attributes(SimulationBlock, nb_attributes, attributes);
		if (fail) {
			so_SimulationBlock_free(SimulationBlock);
			return 1;
		}
		fail = so_Simulation_add_SimulationBlock(self, SimulationBlock);
		if (fail) {
			so_SimulationBlock_free(SimulationBlock);
			return 1;
		}
		self->in_SimulationBlock = 1;
	}
	return 0;
}

void so_Simulation_end_element(so_Simulation *self, const char *localname)
{
	if (strcmp(localname, "SimulationBlock") == 0 && self->in_SimulationBlock) {
		self->in_SimulationBlock = 0;
	} else if (self->in_SimulationBlock) {
		so_SimulationBlock_end_element(self->SimulationBlock[self->num_SimulationBlock - 1], localname);
	}
}

int so_Simulation_characters(so_Simulation *self, const char *ch, int len)
{
	if (self->in_SimulationBlock) {
		int fail = so_SimulationBlock_characters(self->SimulationBlock[self->num_SimulationBlock - 1], ch, len);
		if (fail) return 1;
	}
	return 0;
}
