% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{dt_counts_and_percents}
\alias{dt_counts_and_percents}
\title{Group by, count, and percent count in a data.table}
\usage{
dt_counts_and_percents(DT, group_by_this, percent.cutoff = 0, big.mark = FALSE)
}
\arguments{
\item{DT}{The data.table object to operate on}

\item{group_by_this}{A quoted column to group by}

\item{percent.cutoff}{A percent (out of 100) such that all
the count percents lower than this number will be
grouped into "OTHER" in the returned data.table
(default is 0)}

\item{big.mark}{If \code{FALSE} (default) the "count" column is left
as an integer. If not \code{FALSE}, it must be a
character to separate every three digits of the count.
This turns the count column into a string.}
}
\value{
Returns a data.table with three columns:
        the grouped-by column, a count column, and a
        percent column (out of 100) to two decimal places
}
\description{
This function takes a (quoted) column to group by, counts the
number of occurrences, sorts descending, and adds the percent
of occurrences for each level of the grouped-by column.
}
\details{
For long-tailed count distributions, a cutoff on the percent can be
placed; percent of counts lower than this percent will be grouped
into a category called "OTHER".
The percent is a number out of 100

The final row is a total count

The quoted group-by variable must be a character or factor
}
\examples{

iris_dt <- as.data.table(iris)
dt_counts_and_percents(iris_dt, "Species")
mt <- as.data.table(mtcars)
mt[, cyl:=factor(cyl)]
dt_counts_and_percents(mt, "cyl")
dt_counts_and_percents(mt, "cyl", percent.cutoff=25)

}
