*
* $Id: denlan.F,v 1.1.1.1 1996/04/01 15:02:43 mclareni Exp $
*
* $Log: denlan.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:43  mclareni
* Mathlib gen
*
*
C     This will be DENLAN,IF=DOUBLE and DENLAN64,IF=-DOUBLE
      FUNCTION DENLAN(X)

      DIMENSION P1(0:4),P2(0:4),P3(0:4),P4(0:4),P5(0:4),P6(0:4)
      DIMENSION Q1(0:4),Q2(0:4),Q3(0:4),Q4(0:4),Q5(0:4),Q6(0:4)
      DIMENSION A1(1:3),A2(1:2)

      DATA (P1(I),I=0,4),(Q1(I),I=0,4)
     1/ 0.42598 94875E+0,-0.12497 62550E+0, 0.39842 43700E-1,
     2 -0.62982 87635E-2, 0.15111 62253E-2,
     3  1.0             ,-0.33882 60629E+0, 0.95943 93323E-1,
     4 -0.16080 42283E-1, 0.37789 42063E-2/

      DATA (P2(I),I=0,4),(Q2(I),I=0,4)
     1/ 0.17885 41609E+0, 0.11739 57403E+0, 0.14888 50518E-1,
     2 -0.13949 89411E-2, 0.12836 17211E-3,
     3  1.0             , 0.74287 95082E+0, 0.31539 32961E+0,
     4  0.66942 19548E-1, 0.87906 09714E-2/

      DATA (P3(I),I=0,4),(Q3(I),I=0,4)
     1/ 0.17885 44503E+0, 0.93591 61662E-1, 0.63253 87654E-2,
     2  0.66116 67319E-4,-0.20310 49101E-5,
     3  1.0             , 0.60978 09921E+0, 0.25606 16665E+0,
     4  0.47467 22384E-1, 0.69573 01675E-2/

      DATA (P4(I),I=0,4),(Q4(I),I=0,4)
     1/ 0.98740 54407E+0, 0.11867 23273E+3, 0.84927 94360E+3,
     2 -0.74377 92444E+3, 0.42702 62186E+3,
     3  1.0             , 0.10686 15961E+3, 0.33764 96214E+3,
     4  0.20167 12389E+4, 0.15970 63511E+4/

      DATA (P5(I),I=0,4),(Q5(I),I=0,4)
     1/ 0.10036 75074E+1, 0.16757 02434E+3, 0.47897 11289E+4,
     2  0.21217 86767E+5,-0.22324 94910E+5,
     3  1.0             , 0.15694 24537E+3, 0.37453 10488E+4,
     4  0.98346 98876E+4, 0.66924 28357E+5/

      DATA (P6(I),I=0,4),(Q6(I),I=0,4)
     1/ 0.10008 27619E+1, 0.66491 43136E+3, 0.62972 92665E+5,
     2  0.47555 46998E+6,-0.57436 09109E+7,
     3  1.0             , 0.65141 01098E+3, 0.56974 73333E+5,
     4  0.16591 74725E+6,-0.28157 59939E+7/

      DATA (A1(I),I=1,3)
     1/ 0.41666 66667E-1,-0.19965 27778E-1, 0.27095 38966E-1/

      DATA (A2(I),I=1,2)
     1/-0.18455 68670E+1,-0.42846 40743E+1/

      V=X
      IF(V .LT. -5.5) THEN
       U=EXP(V+1.0)
       DENLAN=0.3989422803*(EXP(-1/U)/SQRT(U))*
     1        (1+(A1(1)+(A1(2)+A1(3)*U)*U)*U)
      ELSEIF(V .LT. -1) THEN
       U=EXP(-V-1)
       DENLAN=EXP(-U)*SQRT(U)*
     1        (P1(0)+(P1(1)+(P1(2)+(P1(3)+P1(4)*V)*V)*V)*V)/
     2        (Q1(0)+(Q1(1)+(Q1(2)+(Q1(3)+Q1(4)*V)*V)*V)*V)
      ELSEIF(V .LT. 1) THEN
       DENLAN=(P2(0)+(P2(1)+(P2(2)+(P2(3)+P2(4)*V)*V)*V)*V)/
     1        (Q2(0)+(Q2(1)+(Q2(2)+(Q2(3)+Q2(4)*V)*V)*V)*V)
      ELSEIF(V .LT. 5) THEN
       DENLAN=(P3(0)+(P3(1)+(P3(2)+(P3(3)+P3(4)*V)*V)*V)*V)/
     1        (Q3(0)+(Q3(1)+(Q3(2)+(Q3(3)+Q3(4)*V)*V)*V)*V)
      ELSEIF(V .LT. 12) THEN
       U=1/V
       DENLAN=U**2*(P4(0)+(P4(1)+(P4(2)+(P4(3)+P4(4)*U)*U)*U)*U)/
     1             (Q4(0)+(Q4(1)+(Q4(2)+(Q4(3)+Q4(4)*U)*U)*U)*U)
      ELSEIF(V .LT. 50) THEN
       U=1/V
       DENLAN=U**2*(P5(0)+(P5(1)+(P5(2)+(P5(3)+P5(4)*U)*U)*U)*U)/
     1             (Q5(0)+(Q5(1)+(Q5(2)+(Q5(3)+Q5(4)*U)*U)*U)*U)
      ELSEIF(V .LT. 300) THEN
       U=1/V
       DENLAN=U**2*(P6(0)+(P6(1)+(P6(2)+(P6(3)+P6(4)*U)*U)*U)*U)/
     1             (Q6(0)+(Q6(1)+(Q6(2)+(Q6(3)+Q6(4)*U)*U)*U)*U)
      ELSE
       U=1/(V-V*LOG(V)/(V+1))
       DENLAN=U**2*(1+(A2(1)+A2(2)*U)*U)
      ENDIF
      RETURN
      END


*
* $Id: dislan.F,v 1.1.1.1 1996/04/01 15:02:43 mclareni Exp $
*
* $Log: dislan.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:43  mclareni
* Mathlib gen
*
*
C     This will be DISLAN,IF=DOUBLE and DISLAN64,IF=-DOUBLE
      FUNCTION DISLAN(X)

      DIMENSION P1(0:4),P2(0:3),P3(0:3),P4(0:3),P5(0:3),P6(0:3)
      DIMENSION Q1(0:4),Q2(0:3),Q3(0:3),Q4(0:3),Q5(0:3),Q6(0:3)
      DIMENSION A1(1:3),A2(1:3)

      DATA (P1(I),I=0,4),(Q1(I),I=0,4)
     1/ 0.25140 91491E+0,-0.62505 80444E-1, 0.14583 81230E-1,
     2 -0.21088 17737E-2, 0.74112 47290E-3,
     3  1.0             ,-0.55711 75625E-2, 0.62253 10236E-1,
     4 -0.31373 78427E-2, 0.19314 96439E-2/

      DATA (P2(I),I=0,3),(Q2(I),I=0,3)
     1/ 0.28683 28584E+0, 0.35643 63231E+0, 0.15235 18695E+0,
     2  0.22513 04883E-1,
     3  1.0             , 0.61911 36137E+0, 0.17207 21448E+0,
     4  0.22785 94771E-1/

      DATA (P3(I),I=0,3),(Q3(I),I=0,3)
     1/ 0.28683 29066E+0, 0.30038 28436E+0, 0.99509 51941E-1,
     2  0.87338 27185E-2,
     3  1.0             , 0.42371 90502E+0, 0.10956 31512E+0,
     4  0.86938 51567E-2/

      DATA (P4(I),I=0,3),(Q4(I),I=0,3)
     1/ 0.10003 51630E+1, 0.45035 92498E+1, 0.10858 83880E+2,
     2  0.75360 52269E+1,
     3  1.0             , 0.55399 69678E+1, 0.19335 81111E+2,
     4  0.27213 21508E+2/

      DATA (P5(I),I=0,3),(Q5(I),I=0,3)
     1/ 0.10000 06517E+1, 0.49094 14111E+2, 0.85055 44753E+2,
     2  0.15321 53455E+3,
     3  1.0             , 0.50099 28881E+2, 0.13998 19104E+3,
     4  0.42000 02909E+3/

      DATA (P6(I),I=0,3),(Q6(I),I=0,3)
     1/ 0.10000 00983E+1, 0.13298 68456E+3, 0.91621 49244E+3,
     2 -0.96050 54274E+3,
     3  1.0             , 0.13398 87843E+3, 0.10559 90413E+4,
     4  0.55322 24619E+3/

      DATA (A1(I),I=1,3)
     1/-0.45833 33333E+0, 0.66753 47222E+0,-0.16417 41416E+1/

      DATA (A2(I),I=1,3)
     1/ 1.0             ,-0.42278 43351E+0,-0.20434 03138E+1/

      ENTRY DSTLAN(X)

      V=X
      IF(V .LT. -5.5) THEN
       U=EXP(V+1)
       DISLAN=0.3989422803*EXP(-1/U)*SQRT(U)*
     1        (1+(A1(1)+(A1(2)+A1(3)*U)*U)*U)
      ELSEIF(V .LT. -1) THEN
       U=EXP(-V-1)
       DISLAN=(EXP(-U)/SQRT(U))*
     1        (P1(0)+(P1(1)+(P1(2)+(P1(3)+P1(4)*V)*V)*V)*V)/
     2        (Q1(0)+(Q1(1)+(Q1(2)+(Q1(3)+Q1(4)*V)*V)*V)*V)
      ELSEIF(V .LT. 1) THEN
       DISLAN=(P2(0)+(P2(1)+(P2(2)+P2(3)*V)*V)*V)/
     1        (Q2(0)+(Q2(1)+(Q2(2)+Q2(3)*V)*V)*V)
      ELSEIF(V .LT. 4) THEN
       DISLAN=(P3(0)+(P3(1)+(P3(2)+P3(3)*V)*V)*V)/
     1        (Q3(0)+(Q3(1)+(Q3(2)+Q3(3)*V)*V)*V)
      ELSEIF(V .LT. 12) THEN
       U=1/V
       DISLAN=(P4(0)+(P4(1)+(P4(2)+P4(3)*U)*U)*U)/
     1        (Q4(0)+(Q4(1)+(Q4(2)+Q4(3)*U)*U)*U)
      ELSEIF(V .LT. 50) THEN
       U=1/V
       DISLAN=(P5(0)+(P5(1)+(P5(2)+P5(3)*U)*U)*U)/
     1        (Q5(0)+(Q5(1)+(Q5(2)+Q5(3)*U)*U)*U)
      ELSEIF(V .LT. 300) THEN
       U=1/V
       DISLAN=(P6(0)+(P6(1)+(P6(2)+P6(3)*U)*U)*U)/
     1        (Q6(0)+(Q6(1)+(Q6(2)+Q6(3)*U)*U)*U)
      ELSE
       U=1/(V-V*LOG(V)/(V+1))
       DISLAN=1-(A2(1)+(A2(2)+A2(3)*U)*U)*U
      ENDIF
      RETURN
      END


*
* $Id: ranlan.F,v 1.1.1.1 1996/04/01 15:02:43 mclareni Exp $
*
* $Log: ranlan.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:43  mclareni
* Mathlib gen
*
*
C     This will be RANLAN,IF=DOUBLE and RANLAN64,IF=-DOUBLE
      FUNCTION RANLAN(X)

      DIMENSION F(6:982)

      DATA (F(I),I= 6,100)
     A/                                                  -2.244733,
     B -2.204365,-2.168163,-2.135219,-2.104898,-2.076740,-2.050397,
     C -2.025605,-2.002150,-1.979866,-1.958612,-1.938275,-1.918760,
     D -1.899984,-1.881879,-1.864385,-1.847451,-1.831030,-1.815083,
     E -1.799574,-1.784473,-1.769751,-1.755383,-1.741346,-1.727620,
     F -1.714187,-1.701029,-1.688130,-1.675477,-1.663057,-1.650858,
     G -1.638868,-1.627078,-1.615477,-1.604058,-1.592811,-1.581729,
     H -1.570806,-1.560034,-1.549407,-1.538919,-1.528565,-1.518339,
     I -1.508237,-1.498254,-1.488386,-1.478628,-1.468976,-1.459428,
     J -1.449979,-1.440626,-1.431365,-1.422195,-1.413111,-1.404112,
     K -1.395194,-1.386356,-1.377594,-1.368906,-1.360291,-1.351746,
     L -1.343269,-1.334859,-1.326512,-1.318229,-1.310006,-1.301843,
     M -1.293737,-1.285688,-1.277693,-1.269752,-1.261863,-1.254024,
     N -1.246235,-1.238494,-1.230800,-1.223153,-1.215550,-1.207990,
     O -1.200474,-1.192999,-1.185566,-1.178172,-1.170817,-1.163500,
     P -1.156220,-1.148977,-1.141770,-1.134598,-1.127459,-1.120354,
     Q -1.113282,-1.106242,-1.099233,-1.092255/

      DATA (F(I),I=101,200)
     A/-1.085306,-1.078388,-1.071498,-1.064636,-1.057802,-1.050996,
     B -1.044215,-1.037461,-1.030733,-1.024029,-1.017350,-1.010695,
     C -1.004064, -.997456, -.990871, -.984308, -.977767, -.971247,
     D  -.964749, -.958271, -.951813, -.945375, -.938957, -.932558,
     E  -.926178, -.919816, -.913472, -.907146, -.900838, -.894547,
     F  -.888272, -.882014, -.875773, -.869547, -.863337, -.857142,
     G  -.850963, -.844798, -.838648, -.832512, -.826390, -.820282,
     H  -.814187, -.808106, -.802038, -.795982, -.789940, -.783909,
     I  -.777891, -.771884, -.765889, -.759906, -.753934, -.747973,
     J  -.742023, -.736084, -.730155, -.724237, -.718328, -.712429,
     K  -.706541, -.700661, -.694791, -.688931, -.683079, -.677236,
     L  -.671402, -.665576, -.659759, -.653950, -.648149, -.642356,
     M  -.636570, -.630793, -.625022, -.619259, -.613503, -.607754,
     N  -.602012, -.596276, -.590548, -.584825, -.579109, -.573399,
     O  -.567695, -.561997, -.556305, -.550618, -.544937, -.539262,
     P  -.533592, -.527926, -.522266, -.516611, -.510961, -.505315,
     Q  -.499674, -.494037, -.488405, -.482777/

      DATA (F(I),I=201,300)
     A/ -.477153, -.471533, -.465917, -.460305, -.454697, -.449092,
     B  -.443491, -.437893, -.432299, -.426707, -.421119, -.415534,
     C  -.409951, -.404372, -.398795, -.393221, -.387649, -.382080,
     D  -.376513, -.370949, -.365387, -.359826, -.354268, -.348712,
     E  -.343157, -.337604, -.332053, -.326503, -.320955, -.315408,
     F  -.309863, -.304318, -.298775, -.293233, -.287692, -.282152,
     G  -.276613, -.271074, -.265536, -.259999, -.254462, -.248926,
     H  -.243389, -.237854, -.232318, -.226783, -.221247, -.215712,
     I  -.210176, -.204641, -.199105, -.193568, -.188032, -.182495,
     J  -.176957, -.171419, -.165880, -.160341, -.154800, -.149259,
     K  -.143717, -.138173, -.132629, -.127083, -.121537, -.115989,
     L  -.110439, -.104889, -.099336, -.093782, -.088227, -.082670,
     M  -.077111, -.071550, -.065987, -.060423, -.054856, -.049288,
     N  -.043717, -.038144, -.032569, -.026991, -.021411, -.015828,
     O  -.010243, -.004656,  .000934,  .006527,  .012123,  .017722,
     P   .023323,  .028928,  .034535,  .040146,  .045759,  .051376,
     Q   .056997,  .062620,  .068247,  .073877/

      DATA (F(I),I=301,400)
     A/  .079511,  .085149,  .090790,  .096435,  .102083,  .107736,
     B   .113392,  .119052,  .124716,  .130385,  .136057,  .141734,
     C   .147414,  .153100,  .158789,  .164483,  .170181,  .175884,
     D   .181592,  .187304,  .193021,  .198743,  .204469,  .210201,
     E   .215937,  .221678,  .227425,  .233177,  .238933,  .244696,
     F   .250463,  .256236,  .262014,  .267798,  .273587,  .279382,
     G   .285183,  .290989,  .296801,  .302619,  .308443,  .314273,
     H   .320109,  .325951,  .331799,  .337654,  .343515,  .349382,
     I   .355255,  .361135,  .367022,  .372915,  .378815,  .384721,
     J   .390634,  .396554,  .402481,  .408415,  .414356,  .420304,
     K   .426260,  .432222,  .438192,  .444169,  .450153,  .456145,
     L   .462144,  .468151,  .474166,  .480188,  .486218,  .492256,
     M   .498302,  .504356,  .510418,  .516488,  .522566,  .528653,
     N   .534747,  .540850,  .546962,  .553082,  .559210,  .565347,
     O   .571493,  .577648,  .583811,  .589983,  .596164,  .602355,
     P   .608554,  .614762,  .620980,  .627207,  .633444,  .639689,
     Q   .645945,  .652210,  .658484,  .664768/

      DATA (F(I),I=401,500)
     A/  .671062,  .677366,  .683680,  .690004,  .696338,  .702682,
     B   .709036,  .715400,  .721775,  .728160,  .734556,  .740963,
     C   .747379,  .753807,  .760246,  .766695,  .773155,  .779627,
     D   .786109,  .792603,  .799107,  .805624,  .812151,  .818690,
     E   .825241,  .831803,  .838377,  .844962,  .851560,  .858170,
     F   .864791,  .871425,  .878071,  .884729,  .891399,  .898082,
     G   .904778,  .911486,  .918206,  .924940,  .931686,  .938446,
     H   .945218,  .952003,  .958802,  .965614,  .972439,  .979278,
     I   .986130,  .992996,  .999875, 1.006769, 1.013676, 1.020597,
     J  1.027533, 1.034482, 1.041446, 1.048424, 1.055417, 1.062424,
     K  1.069446, 1.076482, 1.083534, 1.090600, 1.097681, 1.104778,
     L  1.111889, 1.119016, 1.126159, 1.133316, 1.140490, 1.147679,
     M  1.154884, 1.162105, 1.169342, 1.176595, 1.183864, 1.191149,
     N  1.198451, 1.205770, 1.213105, 1.220457, 1.227826, 1.235211,
     O  1.242614, 1.250034, 1.257471, 1.264926, 1.272398, 1.279888,
     P  1.287395, 1.294921, 1.302464, 1.310026, 1.317605, 1.325203,
     Q  1.332819, 1.340454, 1.348108, 1.355780/

      DATA (F(I),I=501,600)
     A/ 1.363472, 1.371182, 1.378912, 1.386660, 1.394429, 1.402216,
     B  1.410024, 1.417851, 1.425698, 1.433565, 1.441453, 1.449360,
     C  1.457288, 1.465237, 1.473206, 1.481196, 1.489208, 1.497240,
     D  1.505293, 1.513368, 1.521465, 1.529583, 1.537723, 1.545885,
     E  1.554068, 1.562275, 1.570503, 1.578754, 1.587028, 1.595325,
     F  1.603644, 1.611987, 1.620353, 1.628743, 1.637156, 1.645593,
     G  1.654053, 1.662538, 1.671047, 1.679581, 1.688139, 1.696721,
     H  1.705329, 1.713961, 1.722619, 1.731303, 1.740011, 1.748746,
     I  1.757506, 1.766293, 1.775106, 1.783945, 1.792810, 1.801703,
     J  1.810623, 1.819569, 1.828543, 1.837545, 1.846574, 1.855631,
     K  1.864717, 1.873830, 1.882972, 1.892143, 1.901343, 1.910572,
     L  1.919830, 1.929117, 1.938434, 1.947781, 1.957158, 1.966566,
     M  1.976004, 1.985473, 1.994972, 2.004503, 2.014065, 2.023659,
     N  2.033285, 2.042943, 2.052633, 2.062355, 2.072110, 2.081899,
     O  2.091720, 2.101575, 2.111464, 2.121386, 2.131343, 2.141334,
     P  2.151360, 2.161421, 2.171517, 2.181648, 2.191815, 2.202018,
     Q  2.212257, 2.222533, 2.232845, 2.243195/

      DATA (F(I),I=601,700)
     A/ 2.253582, 2.264006, 2.274468, 2.284968, 2.295507, 2.306084,
     B  2.316701, 2.327356, 2.338051, 2.348786, 2.359562, 2.370377,
     C  2.381234, 2.392131, 2.403070, 2.414051, 2.425073, 2.436138,
     D  2.447246, 2.458397, 2.469591, 2.480828, 2.492110, 2.503436,
     E  2.514807, 2.526222, 2.537684, 2.549190, 2.560743, 2.572343,
     F  2.583989, 2.595682, 2.607423, 2.619212, 2.631050, 2.642936,
     G  2.654871, 2.666855, 2.678890, 2.690975, 2.703110, 2.715297,
     H  2.727535, 2.739825, 2.752168, 2.764563, 2.777012, 2.789514,
     I  2.802070, 2.814681, 2.827347, 2.840069, 2.852846, 2.865680,
     J  2.878570, 2.891518, 2.904524, 2.917588, 2.930712, 2.943894,
     K  2.957136, 2.970439, 2.983802, 2.997227, 3.010714, 3.024263,
     L  3.037875, 3.051551, 3.065290, 3.079095, 3.092965, 3.106900,
     M  3.120902, 3.134971, 3.149107, 3.163312, 3.177585, 3.191928,
     N  3.206340, 3.220824, 3.235378, 3.250005, 3.264704, 3.279477,
     O  3.294323, 3.309244, 3.324240, 3.339312, 3.354461, 3.369687,
     P  3.384992, 3.400375, 3.415838, 3.431381, 3.447005, 3.462711,
     Q  3.478500, 3.494372, 3.510328, 3.526370/

      DATA (F(I),I=701,800)
     A/ 3.542497, 3.558711, 3.575012, 3.591402, 3.607881, 3.624450,
     B  3.641111, 3.657863, 3.674708, 3.691646, 3.708680, 3.725809,
     C  3.743034, 3.760357, 3.777779, 3.795300, 3.812921, 3.830645,
     D  3.848470, 3.866400, 3.884434, 3.902574, 3.920821, 3.939176,
     E  3.957640, 3.976215, 3.994901, 4.013699, 4.032612, 4.051639,
     F  4.070783, 4.090045, 4.109425, 4.128925, 4.148547, 4.168292,
     G  4.188160, 4.208154, 4.228275, 4.248524, 4.268903, 4.289413,
     H  4.310056, 4.330832, 4.351745, 4.372794, 4.393982, 4.415310,
     I  4.436781, 4.458395, 4.480154, 4.502060, 4.524114, 4.546319,
     J  4.568676, 4.591187, 4.613854, 4.636678, 4.659662, 4.682807,
     K  4.706116, 4.729590, 4.753231, 4.777041, 4.801024, 4.825179,
     L  4.849511, 4.874020, 4.898710, 4.923582, 4.948639, 4.973883,
     M  4.999316, 5.024942, 5.050761, 5.076778, 5.102993, 5.129411,
     N  5.156034, 5.182864, 5.209903, 5.237156, 5.264625, 5.292312,
     O  5.320220, 5.348354, 5.376714, 5.405306, 5.434131, 5.463193,
     P  5.492496, 5.522042, 5.551836, 5.581880, 5.612178, 5.642734,
     Q  5.673552, 5.704634, 5.735986, 5.767610/

      DATA (F(I),I=801,900)
     A/ 5.799512, 5.831694, 5.864161, 5.896918, 5.929968, 5.963316,
     B  5.996967, 6.030925, 6.065194, 6.099780, 6.134687, 6.169921,
     C  6.205486, 6.241387, 6.277630, 6.314220, 6.351163, 6.388465,
     D  6.426130, 6.464166, 6.502578, 6.541371, 6.580553, 6.620130,
     E  6.660109, 6.700495, 6.741297, 6.782520, 6.824173, 6.866262,
     F  6.908795, 6.951780, 6.995225, 7.039137, 7.083525, 7.128398,
     G  7.173764, 7.219632, 7.266011, 7.312910, 7.360339, 7.408308,
     H  7.456827, 7.505905, 7.555554, 7.605785, 7.656608, 7.708035,
     I  7.760077, 7.812747, 7.866057, 7.920019, 7.974647, 8.029953,
     J  8.085952, 8.142657, 8.200083, 8.258245, 8.317158, 8.376837,
     K  8.437300, 8.498562, 8.560641, 8.623554, 8.687319, 8.751955,
     L  8.817481, 8.883916, 8.951282, 9.019600, 9.088889, 9.159174,
     M  9.230477, 9.302822, 9.376233, 9.450735, 9.526355, 9.603118,
     N  9.681054, 9.760191, 9.840558, 9.922186,10.005107,10.089353,
     O 10.174959,10.261958,10.350389,10.440287,10.531693,10.624646,
     P 10.719188,10.815362,10.913214,11.012789,11.114137,11.217307,
     Q 11.322352,11.429325,11.538283,11.649285/

      DATA (F(I),I=901,982)
     A/11.762390,11.877664,11.995170,12.114979,12.237161,12.361791,
     B 12.488946,12.618708,12.751161,12.886394,13.024498,13.165570,
     C 13.309711,13.457026,13.607625,13.761625,13.919145,14.080314,
     D 14.245263,14.414134,14.587072,14.764233,14.945778,15.131877,
     E 15.322712,15.518470,15.719353,15.925570,16.137345,16.354912,
     F 16.578520,16.808433,17.044929,17.288305,17.538873,17.796967,
     G 18.062943,18.337176,18.620068,18.912049,19.213574,19.525133,
     H 19.847249,20.180480,20.525429,20.882738,21.253102,21.637266,
     I 22.036036,22.450278,22.880933,23.329017,23.795634,24.281981,
     J 24.789364,25.319207,25.873062,26.452634,27.059789,27.696581,
     K 28.365274,29.068370,29.808638,30.589157,31.413354,32.285060,
     L 33.208568,34.188705,35.230920,36.341388,37.527131,38.796172,
     M 40.157721,41.622399,43.202525,44.912465,46.769077,48.792279,
     N 51.005773,53.437996,56.123356,59.103894/

      U=1000*X
      I=U
      U=U-I
      IF(I .GE. 70 .AND. I .LE. 800) THEN
       RANLAN=F(I)+U*(F(I+1)-F(I))
      ELSEIF(I .GE.  7 .AND. I .LE. 980) THEN
       RANLAN=
     1  F(I)+U*(F(I+1)-F(I)-0.25*(1-U)*(F(I+2)-F(I+1)-F(I)+F(I-1)))
      ELSEIF(I. LT. 7) THEN
       V=LOG(X)
       U=1/V
       RANLAN=((0.99858950+(3.45213058E1+1.70854528E1*U)*U)/
     1         (1         +(3.41760202E1+4.01244582  *U)*U))*
     2         (-LOG(-0.91893853-V)-1)
      ELSE
       U=1-X
       V=U**2
       IF(X .LE. 0.999) THEN
        RANLAN=(1.00060006+2.63991156E2*U+4.37320068E3*V)/
     1        ((1         +2.57368075E2*U+3.41448018E3*V)*U)
       ELSE
        RANLAN=(1.00001538+6.07514119E3*U+7.34266409E5*V)/
     1        ((1         +6.06511919E3*U+6.94021044E5*V)*U)
       ENDIF
      ENDIF
      RETURN
      END
      
      
*
* $Id: locatf.F,v 1.2 1996/05/24 10:56:52 jamie Exp $
*
* $Log: locatf.F,v $
* Revision 1.2  1996/05/24 10:56:52  jamie
* add locatr entry for consistency with wrup
*
* Revision 1.1.1.1  1996/02/15 17:48:49  mclareni
* Kernlib
*
*
*
*     Name change (consistancy)
*
      FUNCTION LOCATR(ARRAY,LENGTH,OBJECT)
      DIMENSION ARRAY(*)
      LOCATR=LOCATF(ARRAY,LENGTH,OBJECT)
      END

      FUNCTION LOCATF(ARRAY,LENGTH,OBJECT)
C         BINARY SEARCH THRU 'ARRAY'  TO FIND  'OBJECT'
C         'ARRAY' IS ASSUMED TO BE SORTED PRIOR TO CALL
C         IF MATCH IS FOUND, FUNCTION RETURNS POSITION OF ELEMENT
C         IF NO MATCH FOUND, FUNCTION GIVES NEGATIVE OF NEAREST ELEMENT
C                                SMALLER THAN OBJECT
C         F. JAMES ,  SEPT.,1974
      DIMENSION ARRAY(2)
      NABOVE = LENGTH + 1
      NBELOW = 0
   10 IF (NABOVE-NBELOW .LE. 1)  GO TO 200
      MIDDLE = (NABOVE+NBELOW) / 2
      IF (OBJECT - ARRAY(MIDDLE))  100, 180, 140
  100 NABOVE = MIDDLE
      GO TO 10
  140 NBELOW = MIDDLE
      GO TO 10
  180 LOCATF = MIDDLE
      GO TO 300
  200 LOCATF = -NBELOW
  300 RETURN
      END


*
* $Id: vavset.F,v 1.1.1.1 1996/04/01 15:02:48 mclareni Exp $
*
* $Log: vavset.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:48  mclareni
* Mathlib gen
*
*
      SUBROUTINE VAVSET(RKAPPA,BETA2,MODE)

      COMMON /GXXXC1/ WCM(0:200),AC(0:13),HC(0:8),ITYPE,NPT

      PARAMETER
     1(BKMNX1 = 0.02, BKMNY1 = 0.05, BKMNX2 = 0.12, BKMNY2 = 0.05,
     2 BKMNX3 = 0.22, BKMNY3 = 0.05, BKMXX1 = 0.1 , BKMXY1 = 1   ,
     3 BKMXX2 = 0.2 , BKMXY2 = 1   , BKMXX3 = 0.3 , BKMXY3 = 1   )
      PARAMETER
     1(FBKX1 = 2/(BKMXX1-BKMNX1), FBKX2 = 2/(BKMXX2-BKMNX2),
     2 FBKX3 = 2/(BKMXX3-BKMNX3), FBKY1 = 2/(BKMXY1-BKMNY1),
     3 FBKY2 = 2/(BKMXY2-BKMNY2), FBKY3 = 2/(BKMXY3-BKMNY3))

      DIMENSION EDGEC(2:7),FNINV(5),DRK(5),DSIGM(5),ALFA(2:5)
      DIMENSION U1(13),U2(13),U3(13),U4(12),U5(13),U6(13),U7( 8),U8(13)
      DIMENSION V1(12),V2(12),V3(13),V4(12),V5(13),V6(13),V7(11),V8(11)
      DIMENSION W1(13),W2(11),W3(13),W4(13),W5(13),W6(13),       W8( 8)

      DATA FNINV /1, 0.5, 0.33333333, 0.25, 0.2/

      DATA (EDGEC(J),J=2,7)
     1/ 0.16666667E+0, 0.41666667E-1, 0.83333333E-2,
     2  0.13888889E-1, 0.69444444E-2, 0.77160493E-3/

      DATA (U1(K),K=1,13)
     1/ 0.25850868E+0,  0.32477982E-1, -0.59020496E-2,
     2  0.            , 0.24880692E-1,  0.47404356E-2,
     3 -0.74445130E-3,  0.73225731E-2,  0.           ,
     4  0.11668284E-2,  0.           , -0.15727318E-2,-0.11210142E-2/

      DATA (U2(K),K=1,13)
     1/ 0.43142611E+0,  0.40797543E-1, -0.91490215E-2,
     2  0.           ,  0.42127077E-1,  0.73167928E-2,
     3 -0.14026047E-2,  0.16195241E-1,  0.24714789E-2,
     4  0.20751278E-2,  0.           , -0.25141668E-2,-0.14064022E-2/

      DATA (U3(K),K=1,13)
     1/ 0.25225955E+0,  0.64820468E-1, -0.23615759E-1,
     2  0.           ,  0.23834176E-1,  0.21624675E-2,
     3 -0.26865597E-2, -0.54891384E-2,  0.39800522E-2,
     4  0.48447456E-2, -0.89439554E-2, -0.62756944E-2,-0.24655436E-2/

      DATA (U4(K),K=1,12)
     1/ 0.12593231E+1, -0.20374501E+0,  0.95055662E-1,
     2 -0.20771531E-1, -0.46865180E-1, -0.77222986E-2,
     3  0.32241039E-2,  0.89882920E-2, -0.67167236E-2,
     4 -0.13049241E-1,  0.18786468E-1,  0.14484097E-1/

      DATA (U5(K),K=1,13)
     1/-0.24864376E-1, -0.10368495E-2,  0.14330117E-2,
     2  0.20052730E-3,  0.18751903E-2,  0.12668869E-2,
     3  0.48736023E-3,  0.34850854E-2,  0.           ,
     4 -0.36597173E-3,  0.19372124E-2,  0.70761825E-3, 0.46898375E-3/

      DATA (U6(K),K=1,13)
     1/ 0.35855696E-1, -0.27542114E-1,  0.12631023E-1,
     2 -0.30188807E-2, -0.84479939E-3,  0.           ,
     3  0.45675843E-3, -0.69836141E-2,  0.39876546E-2,
     4 -0.36055679E-2,  0.           ,  0.15298434E-2, 0.19247256E-2/

      DATA (U7(K),K=1,8)
     1/ 0.10234691E+2, -0.35619655E+1,  0.69387764E+0,
     2 -0.14047599E+0, -0.19952390E+1, -0.45679694E+0,
     3  0.           ,  0.50505298E+0/

      DATA (U8(K),K=1,13)
     1/ 0.21487518E+2, -0.11825253E+2,  0.43133087E+1,
     2 -0.14500543E+1, -0.34343169E+1, -0.11063164E+1,
     3 -0.21000819E+0,  0.17891643E+1, -0.89601916E+0,
     4  0.39120793E+0,  0.73410606E+0,  0.           ,-0.32454506E+0/

      DATA (V1(K),K=1,12)
     1/ 0.27827257E+0, -0.14227603E-2,  0.24848327E-2,
     2  0.           ,  0.45091424E-1,  0.80559636E-2,
     3 -0.38974523E-2,  0.           , -0.30634124E-2,
     4  0.75633702E-3,  0.54730726E-2,  0.19792507E-2/

      DATA (V2(K),K=1,12)
     1/ 0.41421789E+0, -0.30061649E-1,  0.52249697E-2,
     2  0.           ,  0.12693873E+0,  0.22999801E-1,
     3 -0.86792801E-2,  0.31875584E-1, -0.61757928E-2,
     4  0.           ,  0.19716857E-1,  0.32596742E-2/

      DATA (V3(K),K=1,13)
     1/ 0.20191056E+0, -0.46831422E-1,  0.96777473E-2,
     2 -0.17995317E-2,  0.53921588E-1,  0.35068740E-2,
     3 -0.12621494E-1, -0.54996531E-2, -0.90029985E-2,
     4  0.34958743E-2,  0.18513506E-1,  0.68332334E-2,-0.12940502E-2/

      DATA (V4(K),K=1,12)
     1/ 0.13206081E+1,  0.10036618E+0, -0.22015201E-1,
     2  0.61667091E-2, -0.14986093E+0, -0.12720568E-1,
     3  0.24972042E-1, -0.97751962E-2,  0.26087455E-1,
     4 -0.11399062E-1, -0.48282515E-1, -0.98552378E-2/

      DATA (V5(K),K=1,13)
     1/ 0.16435243E-1,  0.36051400E-1,  0.23036520E-2,
     2 -0.61666343E-3, -0.10775802E-1,  0.51476061E-2,
     3  0.56856517E-2, -0.13438433E-1,  0.           ,
     4  0.           , -0.25421507E-2,  0.20169108E-2,-0.15144931E-2/

      DATA (V6(K),K=1,13)
     1/ 0.33432405E-1,  0.60583916E-2, -0.23381379E-2,
     2  0.83846081E-3, -0.13346861E-1, -0.17402116E-2,
     3  0.21052496E-2,  0.15528195E-2,  0.21900670E-2,
     4 -0.13202847E-2, -0.45124157E-2, -0.15629454E-2, 0.22499176E-3/

      DATA (V7(K),K=1,11)
     1/ 0.54529572E+1, -0.90906096E+0,  0.86122438E-1,
     2  0.           , -0.12218009E+1, -0.32324120E+0,
     3 -0.27373591E-1,  0.12173464E+0,  0.           ,
     4  0.           ,  0.40917471E-1/

      DATA (V8(K),K=1,11)
     1/ 0.93841352E+1, -0.16276904E+1,  0.16571423E+0,
     2  0.           , -0.18160479E+1, -0.50919193E+0,
     3 -0.51384654E-1,  0.21413992E+0,  0.           ,
     4  0.           ,  0.66596366E-1/

      DATA (W1(K),K=1,13)
     1/ 0.29712951E+0,  0.97572934E-2,  0.           ,
     2 -0.15291686E-2,  0.35707399E-1,  0.96221631E-2,
     3 -0.18402821E-2, -0.49821585E-2,  0.18831112E-2,
     4  0.43541673E-2,  0.20301312E-2, -0.18723311E-2,-0.73403108E-3/

      DATA (W2(K),K=1,11)
     1/ 0.40882635E+0,  0.14474912E-1,  0.25023704E-2,
     2 -0.37707379E-2,  0.18719727E+0,  0.56954987E-1,
     3  0.           ,  0.23020158E-1,  0.50574313E-2,
     4  0.94550140E-2,  0.19300232E-1/

      DATA (W3(K),K=1,13)
     1/ 0.16861629E+0,  0.           ,  0.36317285E-2,
     2 -0.43657818E-2,  0.30144338E-1,  0.13891826E-1,
     3 -0.58030495E-2, -0.38717547E-2,  0.85359607E-2,
     4  0.14507659E-1,  0.82387775E-2, -0.10116105E-1,-0.55135670E-2/

      DATA (W4(K),K=1,13)
     1/ 0.13493891E+1, -0.26863185E-2, -0.35216040E-2,
     2  0.24434909E-1, -0.83447911E-1, -0.48061360E-1,
     3  0.76473951E-2,  0.24494430E-1, -0.16209200E-1,
     4 -0.37768479E-1, -0.47890063E-1,  0.17778596E-1, 0.13179324E-1/

      DATA (W5(K),K=1,13)
     1/ 0.10264945E+0,  0.32738857E-1,  0.           ,
     2  0.43608779E-2, -0.43097757E-1, -0.22647176E-2,
     3  0.94531290E-2, -0.12442571E-1, -0.32283517E-2,
     4 -0.75640352E-2, -0.88293329E-2,  0.52537299E-2, 0.13340546E-2/

      DATA (W6(K),K=1,13)
     1/ 0.29568177E-1, -0.16300060E-2, -0.21119745E-3,
     2  0.23599053E-2, -0.48515387E-2, -0.40797531E-2,
     3  0.40403265E-3,  0.18200105E-2, -0.14346306E-2,
     4 -0.39165276E-2, -0.37432073E-2,  0.19950380E-2, 0.12222675E-2/

      DATA (W8(K),K=1,8)
     1/ 0.66184645E+1, -0.73866379E+0,  0.44693973E-1,
     2  0.           , -0.14540925E+1, -0.39529833E+0,
     3 -0.44293243E-1,  0.88741049E-1/

      ITYPE=0
      IF(RKAPPA .LT. 0.01 .OR. RKAPPA .GT. 12) RETURN
      IF(RKAPPA .GE. 0.29) THEN
       ITYPE=1
       NPT=100
       WK=1/SQRT(RKAPPA)
       AC(0)=(-0.032227*BETA2-0.074275)*RKAPPA+
     1   (0.24533*BETA2+0.070152)*WK+(-0.55610*BETA2-3.1579)
       AC(8)=(-0.013483*BETA2-0.048801)*RKAPPA+
     1   (-1.6921*BETA2+8.3656)*WK+(-0.73275*BETA2-3.5226)
       DRK(1)=WK**2
       DSIGM(1)=SQRT(RKAPPA/(1-0.5*BETA2))
       DO 1 J = 1,4
       DRK(J+1)=DRK(1)*DRK(J)
       DSIGM(J+1)=DSIGM(1)*DSIGM(J)
    1  ALFA(J+1)=(FNINV(J)-BETA2*FNINV(J+1))*DRK(J)

       HC(0)=LOG(RKAPPA)+BETA2+0.42278434
       HC(1)=DSIGM(1)
       HC(2)=ALFA(3)*DSIGM(3)
       HC(3)=(3*ALFA(2)**2+ALFA(4))*DSIGM(4)-3
       HC(4)=(10*ALFA(2)*ALFA(3)+ALFA(5))*DSIGM(5)-10*HC(2)
       HC(5)=HC(2)**2
       HC(6)=HC(2)*HC(3)
       HC(7)=HC(2)*HC(5)
       DO 2 J = 2,7
    2  HC(J)=EDGEC(J)*HC(J)
       HC(8)=0.39894228*HC(1)
      ELSEIF(RKAPPA .GE. 0.22) THEN
       ITYPE=2
       NPT=150
       X=1+(RKAPPA-BKMXX3)*FBKX3
       Y=1+(SQRT(BETA2)-BKMXY3)*FBKY3
       XX=2*X
       YY=2*Y
       X2=XX*X-1
       X3=XX*X2-X
       Y2=YY*Y-1
       Y3=YY*Y2-Y
       XY=X*Y
       P2=X2*Y
       P3=X3*Y
       Q2=Y2*X
       Q3=Y3*X
       PQ=X2*Y2
       AC(1)=W1(1)+W1(2)*X+W1(4)*X3+W1(5)*Y+W1(6)*Y2+W1(7)*Y3+
     1  W1(8)*XY+W1(9)*P2+W1(10)*P3+W1(11)*Q2+W1(12)*Q3+W1(13)*PQ
       AC(2)=W2(1)+W2(2)*X+W2(3)*X2+W2(4)*X3+W2(5)*Y+W2(6)*Y2+
     1  W2(8)*XY+W2(9)*P2+W2(10)*P3+W2(11)*Q2
       AC(3)=W3(1)+W3(3)*X2+W3(4)*X3+W3(5)*Y+W3(6)*Y2+W3(7)*Y3+
     1  W3(8)*XY+W3(9)*P2+W3(10)*P3+W3(11)*Q2+W3(12)*Q3+W3(13)*PQ
       AC(4)=W4(1)+W4(2)*X+W4(3)*X2+W4(4)*X3+W4(5)*Y+W4(6)*Y2+W4(7)*Y3+
     1  W4(8)*XY+W4(9)*P2+W4(10)*P3+W4(11)*Q2+W4(12)*Q3+W4(13)*PQ
       AC(5)=W5(1)+W5(2)*X+W5(4)*X3+W5(5)*Y+W5(6)*Y2+W5(7)*Y3+
     1  W5(8)*XY+W5(9)*P2+W5(10)*P3+W5(11)*Q2+W5(12)*Q3+W5(13)*PQ
       AC(6)=W6(1)+W6(2)*X+W6(3)*X2+W6(4)*X3+W6(5)*Y+W6(6)*Y2+W6(7)*Y3+
     1  W6(8)*XY+W6(9)*P2+W6(10)*P3+W6(11)*Q2+W6(12)*Q3+W6(13)*PQ
       AC(8)=W8(1)+W8(2)*X+W8(3)*X2+W8(5)*Y+W8(6)*Y2+W8(7)*Y3+W8(8)*XY
       AC(0)=-3.05
      ELSEIF(RKAPPA .GE. 0.12) THEN
       ITYPE=3
       NPT=200
       X=1+(RKAPPA-BKMXX2)*FBKX2
       Y=1+(SQRT(BETA2)-BKMXY2)*FBKY2
       XX=2*X
       YY=2*Y
       X2=XX*X-1
       X3=XX*X2-X
       Y2=YY*Y-1
       Y3=YY*Y2-Y
       XY=X*Y
       P2=X2*Y
       P3=X3*Y
       Q2=Y2*X
       Q3=Y3*X
       PQ=X2*Y2
       AC(1)=V1(1)+V1(2)*X+V1(3)*X2+V1(5)*Y+V1(6)*Y2+V1(7)*Y3+
     1  V1(9)*P2+V1(10)*P3+V1(11)*Q2+V1(12)*Q3
       AC(2)=V2(1)+V2(2)*X+V2(3)*X2+V2(5)*Y+V2(6)*Y2+V2(7)*Y3+
     1  V2(8)*XY+V2(9)*P2+V2(11)*Q2+V2(12)*Q3
       AC(3)=V3(1)+V3(2)*X+V3(3)*X2+V3(4)*X3+V3(5)*Y+V3(6)*Y2+V3(7)*Y3+
     1  V3(8)*XY+V3(9)*P2+V3(10)*P3+V3(11)*Q2+V3(12)*Q3+V3(13)*PQ
       AC(4)=V4(1)+V4(2)*X+V4(3)*X2+V4(4)*X3+V4(5)*Y+V4(6)*Y2+V4(7)*Y3+
     1  V4(8)*XY+V4(9)*P2+V4(10)*P3+V4(11)*Q2+V4(12)*Q3
       AC(5)=V5(1)+V5(2)*X+V5(3)*X2+V5(4)*X3+V5(5)*Y+V5(6)*Y2+V5(7)*Y3+
     1  V5(8)*XY+V5(11)*Q2+V5(12)*Q3+V5(13)*PQ
       AC(6)=V6(1)+V6(2)*X+V6(3)*X2+V6(4)*X3+V6(5)*Y+V6(6)*Y2+V6(7)*Y3+
     1  V6(8)*XY+V6(9)*P2+V6(10)*P3+V6(11)*Q2+V6(12)*Q3+V6(13)*PQ
       AC(7)=V7(1)+V7(2)*X+V7(3)*X2+V7(5)*Y+V7(6)*Y2+V7(7)*Y3+
     1  V7(8)*XY+V7(11)*Q2
       AC(8)=V8(1)+V8(2)*X+V8(3)*X2+V8(5)*Y+V8(6)*Y2+V8(7)*Y3+
     1  V8(8)*XY+V8(11)*Q2
       AC(0)=-3.04
      ELSE
       ITYPE=4
       IF(RKAPPA .GE. 0.02) ITYPE=3
       NPT=200
       X=1+(RKAPPA-BKMXX1)*FBKX1
       Y=1+(SQRT(BETA2)-BKMXY1)*FBKY1
       XX=2*X
       YY=2*Y
       X2=XX*X-1
       X3=XX*X2-X
       Y2=YY*Y-1
       Y3=YY*Y2-Y
       XY=X*Y
       P2=X2*Y
       P3=X3*Y
       Q2=Y2*X
       Q3=Y3*X
       PQ=X2*Y2
       IF(ITYPE .EQ. 3) THEN
        AC(1)=U1(1)+U1(2)*X+U1(3)*X2+U1(5)*Y+U1(6)*Y2+U1(7)*Y3+
     1   U1(8)*XY+U1(10)*P3+U1(12)*Q3+U1(13)*PQ
        AC(2)=U2(1)+U2(2)*X+U2(3)*X2+U2(5)*Y+U2(6)*Y2+U2(7)*Y3+
     1   U2(8)*XY+U2(9)*P2+U2(10)*P3+U2(12)*Q3+U2(13)*PQ
        AC(3)=U3(1)+U3(2)*X+U3(3)*X2+U3(5)*Y+U3(6)*Y2+U3(7)*Y3+
     1   U3(8)*XY+U3(9)*P2+U3(10)*P3+U3(11)*Q2+U3(12)*Q3+U3(13)*PQ
        AC(4)=U4(1)+U4(2)*X+U4(3)*X2+U4(4)*X3+U4(5)*Y+U4(6)*Y2+U4(7)*Y3+
     1   U4(8)*XY+U4(9)*P2+U4(10)*P3+U4(11)*Q2+U4(12)*Q3
        AC(5)=U5(1)+U5(2)*X+U5(3)*X2+U5(4)*X3+U5(5)*Y+U5(6)*Y2+U5(7)*Y3+
     1   U5(8)*XY+U5(10)*P3+U5(11)*Q2+U5(12)*Q3+U5(13)*PQ
        AC(6)=U6(1)+U6(2)*X+U6(3)*X2+U6(4)*X3+U6(5)*Y+U6(7)*Y3+
     1   U6(8)*XY+U6(9)*P2+U6(10)*P3+U6(12)*Q3+U6(13)*PQ
        AC(7)=U7(1)+U7(2)*X+U7(3)*X2+U7(4)*X3+U7(5)*Y+U7(6)*Y2+U7(8)*XY
       ENDIF
       AC(8)=U8(1)+U8(2)*X+U8(3)*X2+U8(4)*X3+U8(5)*Y+U8(6)*Y2+U8(7)*Y3+
     1  U8(8)*XY+U8(9)*P2+U8(10)*P3+U8(11)*Q2+U8(13)*PQ
       AC(0)=-3.03
      ENDIF
      AC(9)=(AC(8)-AC(0))/NPT
      AC(10)=1/AC(9)
      IF(ITYPE .EQ. 3) THEN
       X=(AC(7)-AC(8))/(AC(7)*AC(8))
       Y=1/LOG(AC(8)/AC(7))
       P2=AC(7)**2
       AC(11)=P2*(AC(1)*EXP(-AC(2)*(AC(7)+AC(5)*P2)-
     1            AC(3)*EXP(-AC(4)*(AC(7)+AC(6)*P2)))-0.045*Y/AC(7))/
     2            (1+X*Y*AC(7))
       AC(12)=(0.045+X*AC(11))*Y
      ENDIF
      IF(ITYPE .EQ. 4) AC(13)=0.995/DISLAN(AC(8))

      IF(MODE .EQ. 0) RETURN
      X=AC(0)
      WCM(0)=0
      FL=VAVDEN(X)
      DO 11 K = 1,NPT
      X=X+AC(9)
      FU=VAVDEN(X)
      WCM(K)=WCM(K-1)+FL+FU
   11 FL=FU
      X=0.5*AC(9)
      DO 12 K = 1,NPT
   12 WCM(K)=X*WCM(K)
      RETURN
      END



*
* $Id: vavden.F,v 1.1.1.1 1996/04/01 15:02:48 mclareni Exp $
*
* $Log: vavden.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:48  mclareni
* Mathlib gen
*
*
      FUNCTION VAVDEN(RLAM)

      COMMON /GXXXC1/ WCM(0:200),AC(0:13),HC(0:8),ITYPE,NPT

      DIMENSION H(9)

      V=0
      IF(RLAM .LT. AC(0) .OR. RLAM .GT. AC(8)) GO TO 9

      IF(ITYPE .EQ. 1) THEN
       FN=1
       X=(RLAM+HC(0))*HC(1)
       H(1)=X
       H(2)=X**2-1
       DO 1 K = 2,8
       FN=FN+1
    1  H(K+1)=X*H(K)-FN*H(K-1)
       S=1+HC(7)*H(9)
       DO 2 K = 2,6
    2  S=S+HC(K)*H(K+1)
       V=HC(8)*EXP(-0.5*X**2)*MAX(S,0.)
      ELSEIF(ITYPE .EQ. 2) THEN
       X=RLAM**2
       V=AC(1)*EXP(-AC(2)*(RLAM+AC(5)*X)-
     1   AC(3)*EXP(-AC(4)*(RLAM+AC(6)*X)))
      ELSEIF(ITYPE .EQ. 3) THEN
       IF(RLAM .LT. AC(7)) THEN
        X=RLAM**2
        V=AC(1)*EXP(-AC(2)*(RLAM+AC(5)*X)-
     1         AC(3)*EXP(-AC(4)*(RLAM+AC(6)*X)))
       ELSE
        X=1/RLAM
        V=(AC(11)*X+AC(12))*X
       ENDIF
      ELSEIF(ITYPE .EQ. 4) THEN
       V=AC(13)*DENLAN(RLAM)
      ENDIF
    9 VAVDEN=V
      RETURN

      ENTRY VAVDIS(RLAM)

      IF(RLAM .LE. AC(0)) THEN
       V=0
      ELSEIF(RLAM .GE. AC(8)) THEN
       V=1
      ELSE
       X=RLAM-AC(0)
       K=X*AC(10)
       V=MIN(WCM(K)+(X-K*AC(9))*(WCM(K+1)-WCM(K))*AC(10),1.)
      ENDIF
      VAVDIS=V
      RETURN

      ENTRY VAVRND(RAN)

      K=MAX(MIN(ABS(LOCATF(WCM(0),NPT+1,RAN)),NPT)-1,0)
      X=WCM(K+1)-WCM(K)
      V=AC(0)+K*AC(9)
      IF(X .GT. 0) V=V+(RAN-WCM(K))*AC(9)/X
      VAVRND=V
      RETURN
      END


      
*
* $Id: vavran.F,v 1.1.1.1 1996/04/01 15:02:48 mclareni Exp $
*
* $Log: vavran.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:48  mclareni
* Mathlib gen
*
*
      FUNCTION VAVRAN(RKAPPA,BETA2,RAN)

      DIMENSION AC(0:13),HC(0:8),H(9)

      PARAMETER
     1(BKMNX1 = 0.02, BKMNY1 = 0.05, BKMNX2 = 0.12, BKMNY2 = 0.05,
     2 BKMNX3 = 0.22, BKMNY3 = 0.05, BKMXX1 = 0.1 , BKMXY1 = 1   ,
     3 BKMXX2 = 0.2 , BKMXY2 = 1   , BKMXX3 = 0.3 , BKMXY3 = 1   )
      PARAMETER
     1(FBKX1 = 2/(BKMXX1-BKMNX1), FBKX2 = 2/(BKMXX2-BKMNX2),
     2 FBKX3 = 2/(BKMXX3-BKMNX3), FBKY1 = 2/(BKMXY1-BKMNY1),
     3 FBKY2 = 2/(BKMXY2-BKMNY2), FBKY3 = 2/(BKMXY3-BKMNY3))

      DIMENSION EDGEC(2:7),FNINV(5),DRK(5),DSIGM(5),ALFA(2:5)
      DIMENSION U1(13),U2(13),U3(13),U4(12),U5(13),U6(13),U7( 8),U8(13)
      DIMENSION V1(12),V2(12),V3(13),V4(12),V5(13),V6(13),V7(11),V8(11)
      DIMENSION W1(13),W2(11),W3(13),W4(13),W5(13),W6(13),       W8( 8)

      DATA FNINV /1, 0.5, 0.33333333, 0.25, 0.2/

      DATA (EDGEC(J),J=2,7)
     1/ 0.16666667E+0, 0.41666667E-1, 0.83333333E-2,
     2  0.13888889E-1, 0.69444444E-2, 0.77160493E-3/

      DATA (U1(K),K=1,13)
     1/ 0.25850868E+0,  0.32477982E-1, -0.59020496E-2,
     2  0.           ,  0.24880692E-1,  0.47404356E-2,
     3 -0.74445130E-3,  0.73225731E-2,  0.           ,
     4  0.11668284E-2,  0.           , -0.15727318E-2,-0.11210142E-2/

      DATA (U2(K),K=1,13)
     1/ 0.43142611E+0,  0.40797543E-1, -0.91490215E-2,
     2  0.           ,  0.42127077E-1,  0.73167928E-2,
     3 -0.14026047E-2,  0.16195241E-1,  0.24714789E-2,
     4  0.20751278E-2,  0.           , -0.25141668E-2,-0.14064022E-2/

      DATA (U3(K),K=1,13)
     1/ 0.25225955E+0,  0.64820468E-1, -0.23615759E-1,
     2  0.           ,  0.23834176E-1,  0.21624675E-2,
     3 -0.26865597E-2, -0.54891384E-2,  0.39800522E-2,
     4  0.48447456E-2, -0.89439554E-2, -0.62756944E-2,-0.24655436E-2/

      DATA (U4(K),K=1,12)
     1/ 0.12593231E+1, -0.20374501E+0,  0.95055662E-1,
     2 -0.20771531E-1, -0.46865180E-1, -0.77222986E-2,
     3  0.32241039E-2,  0.89882920E-2, -0.67167236E-2,
     4 -0.13049241E-1,  0.18786468E-1,  0.14484097E-1/

      DATA (U5(K),K=1,13)
     1/-0.24864376E-1, -0.10368495E-2,  0.14330117E-2,
     2  0.20052730E-3,  0.18751903E-2,  0.12668869E-2,
     3  0.48736023E-3,  0.34850854E-2,  0.           ,
     4 -0.36597173E-3,  0.19372124E-2,  0.70761825E-3, 0.46898375E-3/

      DATA (U6(K),K=1,13)
     1/ 0.35855696E-1, -0.27542114E-1,  0.12631023E-1,
     2 -0.30188807E-2, -0.84479939E-3,  0.           ,
     3  0.45675843E-3, -0.69836141E-2,  0.39876546E-2,
     4 -0.36055679E-2,  0.           ,  0.15298434E-2, 0.19247256E-2/

      DATA (U7(K),K=1,8)
     1/ 0.10234691E+2, -0.35619655E+1,  0.69387764E+0,
     2 -0.14047599E+0, -0.19952390E+1, -0.45679694E+0,
     3  0.           ,  0.50505298E+0/

      DATA (U8(K),K=1,13)
     1/ 0.21487518E+2, -0.11825253E+2,  0.43133087E+1,
     2 -0.14500543E+1, -0.34343169E+1, -0.11063164E+1,
     3 -0.21000819E+0,  0.17891643E+1, -0.89601916E+0,
     4  0.39120793E+0,  0.73410606E+0,  0.           ,-0.32454506E+0/

      DATA (V1(K),K=1,12)
     1/ 0.27827257E+0, -0.14227603E-2,  0.24848327E-2,
     2  0.           ,  0.45091424E-1,  0.80559636E-2,
     3 -0.38974523E-2,  0.           , -0.30634124E-2,
     4  0.75633702E-3,  0.54730726E-2,  0.19792507E-2/

      DATA (V2(K),K=1,12)
     1/ 0.41421789E+0, -0.30061649E-1,  0.52249697E-2,
     2  0.           ,  0.12693873E+0,  0.22999801E-1,
     3 -0.86792801E-2,  0.31875584E-1, -0.61757928E-2,
     4  0.           ,  0.19716857E-1,  0.32596742E-2/

      DATA (V3(K),K=1,13)
     1/ 0.20191056E+0, -0.46831422E-1,  0.96777473E-2,
     2 -0.17995317E-2,  0.53921588E-1,  0.35068740E-2,
     3 -0.12621494E-1, -0.54996531E-2, -0.90029985E-2,
     4  0.34958743E-2,  0.18513506E-1,  0.68332334E-2,-0.12940502E-2/

      DATA (V4(K),K=1,12)
     1/ 0.13206081E+1,  0.10036618E+0, -0.22015201E-1,
     2  0.61667091E-2, -0.14986093E+0, -0.12720568E-1,
     3  0.24972042E-1, -0.97751962E-2,  0.26087455E-1,
     4 -0.11399062E-1, -0.48282515E-1, -0.98552378E-2/

      DATA (V5(K),K=1,13)
     1/ 0.16435243E-1,  0.36051400E-1,  0.23036520E-2,
     2 -0.61666343E-3, -0.10775802E-1,  0.51476061E-2,
     3  0.56856517E-2, -0.13438433E-1,  0.           ,
     4  0.           , -0.25421507E-2,  0.20169108E-2,-0.15144931E-2/

      DATA (V6(K),K=1,13)
     1/ 0.33432405E-1,  0.60583916E-2, -0.23381379E-2,
     2  0.83846081E-3, -0.13346861E-1, -0.17402116E-2,
     3  0.21052496E-2,  0.15528195E-2,  0.21900670E-2,
     4 -0.13202847E-2, -0.45124157E-2, -0.15629454E-2, 0.22499176E-3/

      DATA (V7(K),K=1,11)
     1/ 0.54529572E+1, -0.90906096E+0,  0.86122438E-1,
     2  0.           , -0.12218009E+1, -0.32324120E+0,
     3 -0.27373591E-1,  0.12173464E+0,  0.           ,
     4  0.           ,  0.40917471E-1/

      DATA (V8(K),K=1,11)
     1/ 0.93841352E+1, -0.16276904E+1,  0.16571423E+0,
     2  0.           , -0.18160479E+1, -0.50919193E+0,
     3 -0.51384654E-1,  0.21413992E+0,  0.           ,
     4  0.           ,  0.66596366E-1/

      DATA (W1(K),K=1,13)
     1/ 0.29712951E+0,  0.97572934E-2,  0.           ,
     2 -0.15291686E-2,  0.35707399E-1,  0.96221631E-2,
     3 -0.18402821E-2, -0.49821585E-2,  0.18831112E-2,
     4  0.43541673E-2,  0.20301312E-2, -0.18723311E-2,-0.73403108E-3/

      DATA (W2(K),K=1,11)
     1/ 0.40882635E+0,  0.14474912E-1,  0.25023704E-2,
     2 -0.37707379E-2,  0.18719727E+0,  0.56954987E-1,
     3  0.           ,  0.23020158E-1,  0.50574313E-2,
     4  0.94550140E-2,  0.19300232E-1/

      DATA (W3(K),K=1,13)
     1/ 0.16861629E+0,  0.           ,  0.36317285E-2,
     2 -0.43657818E-2,  0.30144338E-1,  0.13891826E-1,
     3 -0.58030495E-2, -0.38717547E-2,  0.85359607E-2,
     4  0.14507659E-1,  0.82387775E-2, -0.10116105E-1,-0.55135670E-2/

      DATA (W4(K),K=1,13)
     1/ 0.13493891E+1, -0.26863185E-2, -0.35216040E-2,
     2  0.24434909E-1, -0.83447911E-1, -0.48061360E-1,
     3  0.76473951E-2,  0.24494430E-1, -0.16209200E-1,
     4 -0.37768479E-1, -0.47890063E-1,  0.17778596E-1, 0.13179324E-1/

      DATA (W5(K),K=1,13)
     1/ 0.10264945E+0,  0.32738857E-1,  0.           ,
     2  0.43608779E-2, -0.43097757E-1, -0.22647176E-2,
     3  0.94531290E-2, -0.12442571E-1, -0.32283517E-2,
     4 -0.75640352E-2, -0.88293329E-2,  0.52537299E-2, 0.13340546E-2/

      DATA (W6(K),K=1,13)
     1/ 0.29568177E-1, -0.16300060E-2, -0.21119745E-3,
     2  0.23599053E-2, -0.48515387E-2, -0.40797531E-2,
     3  0.40403265E-3,  0.18200105E-2, -0.14346306E-2,
     4 -0.39165276E-2, -0.37432073E-2,  0.19950380E-2, 0.12222675E-2/

      DATA (W8(K),K=1,8)
     1/ 0.66184645E+1, -0.73866379E+0,  0.44693973E-1,
     2  0.           , -0.14540925E+1, -0.39529833E+0,
     3 -0.44293243E-1,  0.88741049E-1/

      V=0
      IF(RKAPPA .LT. 0.01 .OR. RKAPPA .GT. 12) GO TO 9
      IF(RKAPPA .GE. 0.29) THEN
       ITYPE=1
       NPT=100
       WK=1/SQRT(RKAPPA)
       AC(0)=(-0.032227*BETA2-0.074275)*RKAPPA+
     1   (0.24533*BETA2+0.070152)*WK+(-0.55610*BETA2-3.1579)
       AC(8)=(-0.013483*BETA2-0.048801)*RKAPPA+
     1   (-1.6921*BETA2+8.3656)*WK+(-0.73275*BETA2-3.5226)
       DRK(1)=WK**2
       DSIGM(1)=SQRT(RKAPPA/(1-0.5*BETA2))
       DO 1 J = 1,4
       DRK(J+1)=DRK(1)*DRK(J)
       DSIGM(J+1)=DSIGM(1)*DSIGM(J)
    1  ALFA(J+1)=(FNINV(J)-BETA2*FNINV(J+1))*DRK(J)

       HC(0)=LOG(RKAPPA)+BETA2+0.42278434
       HC(1)=DSIGM(1)
       HC(2)=ALFA(3)*DSIGM(3)
       HC(3)=(3*ALFA(2)**2+ALFA(4))*DSIGM(4)-3
       HC(4)=(10*ALFA(2)*ALFA(3)+ALFA(5))*DSIGM(5)-10*HC(2)
       HC(5)=HC(2)**2
       HC(6)=HC(2)*HC(3)
       HC(7)=HC(2)*HC(5)
       DO 2 J = 2,7
    2  HC(J)=EDGEC(J)*HC(J)
       HC(8)=0.39894228*HC(1)
      ELSEIF(RKAPPA .GE. 0.22) THEN
       ITYPE=2
       NPT=150
       X=1+(RKAPPA-BKMXX3)*FBKX3
       Y=1+(SQRT(BETA2)-BKMXY3)*FBKY3
       XX=2*X
       YY=2*Y
       X2=XX*X-1
       X3=XX*X2-X
       Y2=YY*Y-1
       Y3=YY*Y2-Y
       XY=X*Y
       P2=X2*Y
       P3=X3*Y
       Q2=Y2*X
       Q3=Y3*X
       PQ=X2*Y2
       AC(1)=W1(1)+W1(2)*X+W1(4)*X3+W1(5)*Y+W1(6)*Y2+W1(7)*Y3+
     1  W1(8)*XY+W1(9)*P2+W1(10)*P3+W1(11)*Q2+W1(12)*Q3+W1(13)*PQ
       AC(2)=W2(1)+W2(2)*X+W2(3)*X2+W2(4)*X3+W2(5)*Y+W2(6)*Y2+
     1  W2(8)*XY+W2(9)*P2+W2(10)*P3+W2(11)*Q2
       AC(3)=W3(1)+W3(3)*X2+W3(4)*X3+W3(5)*Y+W3(6)*Y2+W3(7)*Y3+
     1  W3(8)*XY+W3(9)*P2+W3(10)*P3+W3(11)*Q2+W3(12)*Q3+W3(13)*PQ
       AC(4)=W4(1)+W4(2)*X+W4(3)*X2+W4(4)*X3+W4(5)*Y+W4(6)*Y2+W4(7)*Y3+
     1  W4(8)*XY+W4(9)*P2+W4(10)*P3+W4(11)*Q2+W4(12)*Q3+W4(13)*PQ
       AC(5)=W5(1)+W5(2)*X+W5(4)*X3+W5(5)*Y+W5(6)*Y2+W5(7)*Y3+
     1  W5(8)*XY+W5(9)*P2+W5(10)*P3+W5(11)*Q2+W5(12)*Q3+W5(13)*PQ
       AC(6)=W6(1)+W6(2)*X+W6(3)*X2+W6(4)*X3+W6(5)*Y+W6(6)*Y2+W6(7)*Y3+
     1  W6(8)*XY+W6(9)*P2+W6(10)*P3+W6(11)*Q2+W6(12)*Q3+W6(13)*PQ
       AC(8)=W8(1)+W8(2)*X+W8(3)*X2+W8(5)*Y+W8(6)*Y2+W8(7)*Y3+W8(8)*XY
       AC(0)=-3.05
      ELSEIF(RKAPPA .GE. 0.12) THEN
       ITYPE=3
       NPT=200
       X=1+(RKAPPA-BKMXX2)*FBKX2
       Y=1+(SQRT(BETA2)-BKMXY2)*FBKY2
       XX=2*X
       YY=2*Y
       X2=XX*X-1
       X3=XX*X2-X
       Y2=YY*Y-1
       Y3=YY*Y2-Y
       XY=X*Y
       P2=X2*Y
       P3=X3*Y
       Q2=Y2*X
       Q3=Y3*X
       PQ=X2*Y2
       AC(1)=V1(1)+V1(2)*X+V1(3)*X2+V1(5)*Y+V1(6)*Y2+V1(7)*Y3+
     1  V1(9)*P2+V1(10)*P3+V1(11)*Q2+V1(12)*Q3
       AC(2)=V2(1)+V2(2)*X+V2(3)*X2+V2(5)*Y+V2(6)*Y2+V2(7)*Y3+
     1  V2(8)*XY+V2(9)*P2+V2(11)*Q2+V2(12)*Q3
       AC(3)=V3(1)+V3(2)*X+V3(3)*X2+V3(4)*X3+V3(5)*Y+V3(6)*Y2+V3(7)*Y3+
     1  V3(8)*XY+V3(9)*P2+V3(10)*P3+V3(11)*Q2+V3(12)*Q3+V3(13)*PQ
       AC(4)=V4(1)+V4(2)*X+V4(3)*X2+V4(4)*X3+V4(5)*Y+V4(6)*Y2+V4(7)*Y3+
     1  V4(8)*XY+V4(9)*P2+V4(10)*P3+V4(11)*Q2+V4(12)*Q3
       AC(5)=V5(1)+V5(2)*X+V5(3)*X2+V5(4)*X3+V5(5)*Y+V5(6)*Y2+V5(7)*Y3+
     1  V5(8)*XY+V5(11)*Q2+V5(12)*Q3+V5(13)*PQ
       AC(6)=V6(1)+V6(2)*X+V6(3)*X2+V6(4)*X3+V6(5)*Y+V6(6)*Y2+V6(7)*Y3+
     1  V6(8)*XY+V6(9)*P2+V6(10)*P3+V6(11)*Q2+V6(12)*Q3+V6(13)*PQ
       AC(7)=V7(1)+V7(2)*X+V7(3)*X2+V7(5)*Y+V7(6)*Y2+V7(7)*Y3+
     1  V7(8)*XY+V7(11)*Q2
       AC(8)=V8(1)+V8(2)*X+V8(3)*X2+V8(5)*Y+V8(6)*Y2+V8(7)*Y3+
     1  V8(8)*XY+V8(11)*Q2
       AC(0)=-3.04
      ELSE
       ITYPE=4
       IF(RKAPPA .GE. 0.02) ITYPE=3
       NPT=200
       X=1+(RKAPPA-BKMXX1)*FBKX1
       Y=1+(SQRT(BETA2)-BKMXY1)*FBKY1
       XX=2*X
       YY=2*Y
       X2=XX*X-1
       X3=XX*X2-X
       Y2=YY*Y-1
       Y3=YY*Y2-Y
       XY=X*Y
       P2=X2*Y
       P3=X3*Y
       Q2=Y2*X
       Q3=Y3*X
       PQ=X2*Y2
       IF(ITYPE .EQ. 3) THEN
        AC(1)=U1(1)+U1(2)*X+U1(3)*X2+U1(5)*Y+U1(6)*Y2+U1(7)*Y3+
     1   U1(8)*XY+U1(10)*P3+U1(12)*Q3+U1(13)*PQ
        AC(2)=U2(1)+U2(2)*X+U2(3)*X2+U2(5)*Y+U2(6)*Y2+U2(7)*Y3+
     1   U2(8)*XY+U2(9)*P2+U2(10)*P3+U2(12)*Q3+U2(13)*PQ
        AC(3)=U3(1)+U3(2)*X+U3(3)*X2+U3(5)*Y+U3(6)*Y2+U3(7)*Y3+
     1   U3(8)*XY+U3(9)*P2+U3(10)*P3+U3(11)*Q2+U3(12)*Q3+U3(13)*PQ
        AC(4)=U4(1)+U4(2)*X+U4(3)*X2+U4(4)*X3+U4(5)*Y+U4(6)*Y2+U4(7)*Y3+
     1   U4(8)*XY+U4(9)*P2+U4(10)*P3+U4(11)*Q2+U4(12)*Q3
        AC(5)=U5(1)+U5(2)*X+U5(3)*X2+U5(4)*X3+U5(5)*Y+U5(6)*Y2+U5(7)*Y3+
     1   U5(8)*XY+U5(10)*P3+U5(11)*Q2+U5(12)*Q3+U5(13)*PQ
        AC(6)=U6(1)+U6(2)*X+U6(3)*X2+U6(4)*X3+U6(5)*Y+U6(7)*Y3+
     1   U6(8)*XY+U6(9)*P2+U6(10)*P3+U6(12)*Q3+U6(13)*PQ
        AC(7)=U7(1)+U7(2)*X+U7(3)*X2+U7(4)*X3+U7(5)*Y+U7(6)*Y2+U7(8)*XY
       ENDIF
       AC(8)=U8(1)+U8(2)*X+U8(3)*X2+U8(4)*X3+U8(5)*Y+U8(6)*Y2+U8(7)*Y3+
     1  U8(8)*XY+U8(9)*P2+U8(10)*P3+U8(11)*Q2+U8(13)*PQ
       AC(0)=-3.03
      ENDIF
      AC(9)=(AC(8)-AC(0))/NPT
      IF(ITYPE .EQ. 3) THEN
       X=(AC(7)-AC(8))/(AC(7)*AC(8))
       Y=1/LOG(AC(8)/AC(7))
       P2=AC(7)**2
       AC(11)=P2*(AC(1)*EXP(-AC(2)*(AC(7)+AC(5)*P2)-
     1            AC(3)*EXP(-AC(4)*(AC(7)+AC(6)*P2)))-0.045*Y/AC(7))/
     2            (1+X*Y*AC(7))
       AC(12)=(0.045+X*AC(11))*Y
      ENDIF
      IF(ITYPE .EQ. 4) AC(10)=0.995/DISLAN(AC(8))

      T=2*RAN/AC(9)
      RLAM=AC(0)
      FL=0
      S=0
      DO 21 N = 1,NPT
      RLAM=RLAM+AC(9)
      IF(ITYPE .EQ. 1) THEN
       FN=1
       X=(RLAM+HC(0))*HC(1)
       H(1)=X
       H(2)=X**2-1
       DO 31 K = 2,8
       FN=FN+1
   31  H(K+1)=X*H(K)-FN*H(K-1)
       Y=1+HC(7)*H(9)
       DO 32 K = 2,6
   32  Y=Y+HC(K)*H(K+1)
       FU=HC(8)*EXP(-0.5*X**2)*MAX(Y,0.)
      ELSEIF(ITYPE .EQ. 2) THEN
       X=RLAM**2
       FU=AC(1)*EXP(-AC(2)*(RLAM+AC(5)*X)-
     1    AC(3)*EXP(-AC(4)*(RLAM+AC(6)*X)))
      ELSEIF(ITYPE .EQ. 3) THEN
       IF(RLAM .LT. AC(7)) THEN
        X=RLAM**2
        FU=AC(1)*EXP(-AC(2)*(RLAM+AC(5)*X)-
     1     AC(3)*EXP(-AC(4)*(RLAM+AC(6)*X)))
       ELSE
        X=1/RLAM
        FU=(AC(11)*X+AC(12))*X
       ENDIF
      ELSE
       FU=AC(10)*DENLAN(RLAM)
      ENDIF
      S=S+FL+FU
      IF(S .GT. T) GO TO 22
   21 FL=FU

   22 S0=S-FL-FU
      V=RLAM-AC(9)
      IF(S .GT. S0) V=V+AC(9)*(T-S0)/(S-S0)
    9 VAVRAN=V
      RETURN
      END
