% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogEvent.R
\name{as.data.frame.LogEvent}
\alias{as.data.frame.LogEvent}
\alias{as.data.table.LogEvent}
\alias{as_tibble.LogEvent}
\title{Coerce LogEvents to Data Frames}
\usage{
\method{as.data.frame}{LogEvent}(x, row.names = NULL, optional = FALSE,
  stringsAsFactors = default.stringsAsFactors(), strict = FALSE, ...)

as.data.table.LogEvent(x, ...)

as_tibble.LogEvent(x, ...)
}
\arguments{
\item{x}{any \R object.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{currently ignored}

\item{stringsAsFactors}{logical: should the character vector be converted
    to a factor?}

\item{strict}{If \code{TRUE} as.data.frame will fail if \code{x} contains values that
cannot be included in a data.frame. Ff \code{FALSE} (the default) they will
be coerced}

\item{...}{passed on to \code{data.frame()}}
}
\description{
Coerce LogEvents to \code{data.frames}, \code{\link[data.table:data.table]{data.tables}},
or \code{\link[tibble:tibble]{tibbles}}.
}
\examples{
l <- Logger$new("test")
l$info("lorem ipsum")
as.data.frame(l$last_event)

l$info("rememver LogEvents can store any custom log values", df = iris)
as.data.frame(l$last_event)
head(as.data.frame(l$last_event)$df[[1]])

}
\seealso{
\link[data.table:data.table]{data.table::data.table}, \link[tibble:tibble]{tibble::tibble}
}
