% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lgcpStructures.R
\name{PriorSpec.list}
\alias{PriorSpec.list}
\title{PriorSpec.list function}
\usage{
\method{PriorSpec}{list}(obj, ...)
}
\arguments{
\item{obj}{a list object defining a prior , see ?GaussianPrior and ?LogGaussianPrior}

\item{...}{additional arguments}
}
\value{
an object suitable for use in a call to the MCMC routines
}
\description{
Method for declaring a Bayesian prior density in lgcp. Checks to confirm that the object obj has the requisite components for functioning as a prior.
}
\examples{
\dontrun{PriorSpec(LogGaussianPrior(mean=log(c(1,500)),variance=diag(0.15,2)))}
\dontrun{PriorSpec(GaussianPrior(mean=rep(0,9),variance=diag(10^6,9)))}
}
\seealso{
\link{GaussianPrior}, \link{LogGaussianPrior}
}

