% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumContrast.R
\name{my.KinhomAverage}
\alias{my.KinhomAverage}
\title{my.KinhomAverage function}
\usage{
my.KinhomAverage(xyt, spatial.intensity, temporal.intensity,
  time.window = xyt$tlim, rvals = NULL, correction = "iso",
  suppresswarnings = FALSE, verbose = TRUE)
}
\arguments{
\item{xyt}{an object of class stppp.}

\item{spatial.intensity}{A spatialAtRisk object giving the possibly inhomogeneous underlying fixed spatial density of the data.}

\item{temporal.intensity}{A temporalAtRisk object giving the possibly inhomogeneous underlying fixed temporal intensity of the data.}

\item{time.window}{Time interval contained in the interval xyt$tlim over which to compute average. Useful if there is a lot of data over a lot of time points.}

\item{rvals}{Vector of values for the argument r at which g(r) should be evaluated (see ?Kinhom). There is a sensible default.}

\item{correction}{Choice of edge correction to use, see ?Kinhom, default is Ripley isotropic correction.}

\item{suppresswarnings}{Whether or not to suppress warnings generated by Kinhom.}

\item{verbose}{Whether or not to print function comments and progress to the console during execution. Defaults to TRUE.}
}
\value{
A vector corresponding to the time-averaged K function for spatiotemporal data, evaluated at spatial lags defined by 'rvals'.
}
\description{
A carbon-copy of KinhomAverage from package 'lgcp', with extra control over the printing of progress bars and other output to the console during execution. 
Computes the time-averaged version of the nonparametric K function (for use with spatiotemporal data).
}

