% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupRegularizedSEM.R
\name{.computeInitialHessian}
\alias{.computeInitialHessian}
\title{.computeInitialHessian}
\usage{
.computeInitialHessian(
  initialHessian,
  rawParameters,
  lavaanModel,
  SEM,
  addMeans,
  stepSize,
  notes = NULL
)
}
\arguments{
\item{initialHessian}{option to provide an initial Hessian to the optimizer.
Must have row and column names corresponding to the parameter labels. use
getLavaanParameters(lavaanModel) to
see those labels. If set to "scoreBased", the outer product of the scores
will be used as an approximation
(see https://en.wikipedia.org/wiki/Berndt\%E2\%80\%93Hall\%E2\%80\%93Hall\%E2\%80\%93Hausman_algorithm).
If set to "compute", the initial hessian will be computed. If set to a single
value, a diagonal matrix with the single value along the diagonal will be used.
The default is "lavaan" which extracts the Hessian from the lavaanModel. This Hessian
will typically deviate from that of the internal SEM represenation of lessSEM (due to
the transformation of the variances), but works quite well in practice.}

\item{rawParameters}{vector with raw parameters}

\item{lavaanModel}{lavaan model object}

\item{SEM}{internal SEM representation}

\item{addMeans}{should a mean structure be added to the model?}

\item{stepSize}{initial step size}

\item{notes}{option to pass a notes to function. All notes of the current
function will be added}
}
\value{
Hessian matrix and notes
}
\description{
computes the initial Hessian used in the optimization. Because we use the parameter
estimates from lavaan as starting values, it typcially makes sense to just use the
Hessian of the lavaan model as initial Hessian
}
\keyword{internal}
