% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{duplicate_env}
\alias{duplicate_env}
\title{Create a duplicate of an environment}
\usage{
duplicate_env(envir, parent = parent.env(envir))
}
\arguments{
\item{envir}{environment to duplicate}

\item{parent}{parent environment to set for the new environment.  Defaults to
the parent environment of \code{envir}.}
}
\value{
A duplicated copy of \code{envir} whose parent env is \code{parent}.
}
\description{
Copy all items from the environment to a new environment. By default, the new
environment will share the same parent environment.
}
\examples{
# Make a new environment with the object 'key'
envir <- new.env()
envir$key <- "value"
"key" \%in\% ls() # FALSE
"key" \%in\% ls(envir = envir) # TRUE

# Duplicate the envir and show it contains 'key'
new_envir <- duplicate_env(envir)
"key" \%in\% ls(envir = new_envir) # TRUE

}
