% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{addLegendAwesomeIcon}
\alias{addLegendAwesomeIcon}
\title{Add a legend with Awesome Icons}
\usage{
addLegendAwesomeIcon(
  map,
  iconSet,
  title = NULL,
  labelStyle = "",
  orientation = c("vertical", "horizontal"),
  marker = TRUE,
  group = NULL,
  className = "info legend leaflet-control",
  ...
)
}
\arguments{
\item{map}{a map widget object created from 'leaflet'}

\item{iconSet}{a named list from \link[leaflet]{awesomeIconList}, the names will be the
labels in the legend}

\item{title}{the legend title, pass in HTML to style}

\item{labelStyle}{character string of style argument for HTML text}

\item{orientation}{stack the legend items vertically or horizontally}

\item{marker}{whether to show the marker or only the icon}

\item{group}{group name of a leaflet layer group}

\item{className}{extra CSS class to append to the control, space separated}

\item{...}{arguments to pass to \link[leaflet]{addControl}}
}
\value{
an object from \link[leaflet]{addControl}
}
\description{
Add a legend with Awesome Icons
}
\examples{
library(leaflet)
data(quakes)
iconSet <- awesomeIconList(
  `Font Awesome` = makeAwesomeIcon(icon = "font-awesome", library = "fa",
                                   iconColor = 'gold', markerColor = 'red',
                                   spin = FALSE,
                                   squareMarker = TRUE,
                                   iconRotate = 30,
  ),
  Ionic = makeAwesomeIcon(icon = "ionic", library = "ion",
                          iconColor = '#ffffff', markerColor = 'blue',
                          spin = TRUE,
                          squareMarker = FALSE),
  Glyphicon = makeAwesomeIcon(icon = "plus-sign", library = "glyphicon",
                              iconColor = 'rgb(192, 255, 0)',
                              markerColor = 'darkpurple',
                              spin = TRUE,
                              squareMarker = FALSE)
)
leaflet(quakes[1:3,]) \%>\%
  addTiles() \%>\%
  addAwesomeMarkers(lat = ~lat,
                    lng = ~long,
                    icon = iconSet) \%>\%
  addLegendAwesomeIcon(iconSet = iconSet,
                       orientation = 'horizontal',
                       title = htmltools::tags$div(
                         style = 'font-size: 20px;',
                         'Awesome Icons'),
                       labelStyle = 'font-size: 16px;') \%>\%
  addLegendAwesomeIcon(iconSet = iconSet,
                       orientation = 'vertical',
                       marker = FALSE,
                       title = htmltools::tags$div(
                         style = 'font-size: 20px;',
                         'Awesome Icons'),
                       labelStyle = 'font-size: 16px;')
}
