% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDS_reconstruction.R
\name{one_lds_cv}
\alias{one_lds_cv}
\title{One cross-validation run}
\usage{
one_lds_cv(
  z,
  instPeriod,
  mu,
  y,
  u,
  v,
  method = "EM",
  num.restarts = 20,
  ub = NULL,
  lb = NULL,
  num.islands = 4,
  pop.per.island = 100,
  niter = 1000,
  tol = 1e-06,
  use.raw = FALSE
)
}
\arguments{
\item{z}{A vector of left-out points, indexed according to the intrumental period}

\item{instPeriod}{indices of the instrumental period in the whole record}

\item{mu}{Mean of the observations}

\item{y}{Catchment output, preprocessed from data}

\item{u}{Input matrix for a single-model reconstruction, or a list of input matrices for an ensemble reconstruction.}

\item{v}{Same as u.}

\item{method}{By default this is "EM". There are experimental methods but you should not try.}

\item{num.restarts}{The number of initial conditions to start the EM search; ignored if \code{init} is provided.}

\item{ub}{Upper bounds, a vector whose length is the number of parameters}

\item{lb}{Lower bounds}

\item{num.islands}{Number of islands (if method is GA; experimental)}

\item{pop.per.island}{Initial population per island (if method is GA; experimental)}

\item{niter}{Maximum number of iterations, default 1000}

\item{tol}{Tolerance for likelihood convergence, default 1e-5. Note that the log-likelihood is normalized by dividing by the number of observations.}

\item{use.raw}{Whether performance metrics are calculated on the raw time series. Experimental; don't use.}
}
\value{
A vector of prediction.
}
\description{
Make one prediction for one cross-validation run. This is a subroutine that is called by cvLDS, without any checks. You should not need to use this directly.
}
