% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastics.R
\name{one_LDS_rep}
\alias{one_LDS_rep}
\title{One LDS replicate}
\usage{
one_LDS_rep(
  rep.num,
  theta,
  u = NULL,
  v = NULL,
  years,
  mu = 0,
  exp.trans = TRUE
)
}
\arguments{
\item{rep.num}{The ID number of the replicate}

\item{theta}{A list of parameters: A, B, C, D, Q, R, x0, v0}

\item{u}{Input matrix for the state equation (m_u rows, T columns)}

\item{v}{Input matrix for the output equation (m_v rows, T columns)}

\item{years}{The years of the study horizon}

\item{mu}{Mean of the log-transformed streamflow process}

\item{exp.trans}{Whether exponential transformation back to the streamflow space is required.
If TRUE, both Y and Q are returned, otherwise only Y.}
}
\value{
A data.table. The first column is the years of the study horizon, as supplied by \code{year}.
Subsequent columns are \code{simX}, \code{simY}, and \code{simQ} which are the simulated catchment state (X),
log-transformed and centralized flow (Y) and flow (Q). The last column is the replicate ID number.
}
\description{
Generate a single stochastic time series from an LDS model
}
\examples{
# Learn theta
one_LDS_rep(1, theta, t(NPpc), t(NPpc), 1200:2012, mu = mean(log(NPannual$Qa)))
}
