% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{sliouvm}
\alias{sliouvm}
\title{Marginal survival function for Liouville copulas}
\usage{
sliouvm(x, family, alpha, theta)
}
\arguments{
\item{x}{sample from copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alpha}{marginal allocation parameter (must be integer)}

\item{theta}{parameter of the corresponding Archimedean copula}
}
\value{
a vector of same length as \code{x} with the survival probabilities
}
\description{
Default behavior as in original GumbelLiouville.R
}
\examples{
x <- rliouv(n = 100, family = "gumbel", alphavec <- c(2,3), theta = 2)
sliouvm(x[,1], family="gumbel", alpha=alphavec[1], theta=2)
}

