% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f-interp.R
\name{f_interp}
\alias{f_interp}
\alias{uq}
\alias{uqf}
\alias{uqs}
\title{Interpolate a formula}
\usage{
f_interp(f, data = NULL)

uq(x, data = NULL)

uqf(x)

uqs(x)
}
\arguments{
\item{f}{A one-sided formula.}

\item{data}{When called from inside \code{f_eval}, this is used to pass on
the data so that nested formulas are evaluated in the correct environment.}

\item{x}{For \code{uq} and \code{uqf}, a formula. For \code{uqs}, a
a vector.}
}
\description{
Interpolation replaces sub-expressions of the form \code{uq(x)} with
the evaluated value of \code{x}, and inlines sub-expressions of
the form \code{uqs(x)}.
}
\section{Theory}{

Formally, \code{f_interp} is a quasiquote function, \code{uq()} is the
unquote operator, and \code{uqs()} is the unquote splice operator.
These terms have a rich history in LISP, and live on in modern languages
like \href{Julia}{http://docs.julialang.org/en/release-0.1/manual/metaprogramming/}
and \href{Racket}{https://docs.racket-lang.org/reference/quasiquote.html}.
}
\examples{
f_interp(x ~ 1 + uq(1 + 2 + 3) + 10)

# Use uqs() if you want to add multiple arguments to a function
# It must evaluate to a list
args <- list(1:10, na.rm = TRUE)
f_interp(~ mean( uqs(args) ))

# You can combine the two
var <- quote(xyz)
extra_args <- list(trim = 0.9)
f_interp(~ mean( uq(var) , uqs(extra_args) ))

foo <- function(n) {
  ~ 1 + uq(n)
}
f <- foo(10)
f
f_interp(f)
}

