% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erase.R
\name{lawn_difference}
\alias{lawn_difference}
\title{Difference}
\usage{
lawn_difference(poly1, poly2, lint = FALSE)
}
\arguments{
\item{poly1}{A \link{data-Feature}<(\link{data-Polygon})> feature}

\item{poly2}{\link{data-Feature}<(\link{data-Polygon})> to erase from poly1}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a \link{data-Feature}<(\link{data-Polygon})> feature showing the area of poly1
excluding the area of poly2
}
\description{
Finds the difference between two \link{data-Polygon}'s by clipping
the second polygon from the first.
}
\examples{
\dontrun{
# skipping on cran
poly1 <- '{
 "type": "Feature",
  "properties": {
    "fill": "#0f0"
  },
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-46.738586, -23.596711],
      [-46.738586, -23.458207],
      [-46.560058, -23.458207],
      [-46.560058, -23.596711],
      [-46.738586, -23.596711]
    ]]
  }
}'

poly2 <- '{
  "type": "Feature",
  "properties": {
    "fill": "#00f"
  },
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-46.650009, -23.631314],
      [-46.650009, -23.5237],
      [-46.509246, -23.5237],
      [-46.509246, -23.631314],
      [-46.650009, -23.631314]
    ]]
  }
}'
lawn_difference(poly1, poly2)
}
\dontrun{
lawn_featurecollection(list(poly1, poly2)) \%>\% view
lawn_difference(poly1, poly2) \%>\% view
fc <- lawn_featurecollection(list(
   lawn_polygon(jsonlite::fromJSON(poly1)$geometry$coordinates),
   lawn_polygon(jsonlite::fromJSON(poly2)$geometry$coordinates)
))
view(fc)
}
}
\seealso{
Other transformations: 
\code{\link{lawn_bezier}()},
\code{\link{lawn_buffer}()},
\code{\link{lawn_concave}()},
\code{\link{lawn_convex}()},
\code{\link{lawn_intersect}()},
\code{\link{lawn_merge}()},
\code{\link{lawn_simplify}()},
\code{\link{lawn_union}()}
}
\concept{transformations}
