# export `lavaan' lav model description to third-party software
# 

lavExport <- function(object, target="lavaan", file=NULL) {

    target <- tolower(target)

    if("lavaan" %in% class(object)) {
        lav <- object@ParTable
    } else if(is.list(object)) {
        lav <- object
    } else {
        stop("lavaan ERROR: object must be of class `lavaan' or a parTable")
    }

    if(target == "lavaan") {
        model <- export_lavaan(lav)
    } else if(target == "mplus") {
        model <- export_mplus(lav)
    } else if(target == "lisrel") {
        model <- export_lisrel(lav)
    } else if(target == "eqs") {
        model <- export_eqs(lav)
    } else if(target == "sem") {
        model <- export_sem(lav)
    } else if(target == "openmx") {
        model <- export_openmx(lav)
    } else {
        stop("lavaan ERROR: target", target, "has not been implemented yet")
    }
    
    if(!is.null(file)) {
        cat(model, file=file)
        return(invisible(model))
    } else {
        return(model)
    }
}

## FIXME: this is completely UNFINISHED (just  used to quickly get something)
export_lavaan <- function(lav) {

    # check if ustart is missing; if so, look for est and assume free=0
    if(is.null(lav$ustart)) lav$ustart <- lav$est

    # check if free is missing
    if(is.null(lav$free)) lav$free <- rep(0L, length(lav$ustart))

    # check if label is missing
    if(is.null(lav$label)) lav$label <- rep("", length(lav$ustart))


    header <- "# this model syntax is autogenerated by lavExport\n"
    footer <- "\n"
    lav2 <- ifelse(lav$free != 0L,
                   ifelse(lav$label == "",
                          paste(lav$lhs, lav$op, lav$rhs),
                          paste(lav$lhs, lav$op, lav$label, "*", lav$rhs)
                   ),
                   ifelse(lav$label == "",
                          paste(lav$lhs, lav$op, lav$ustart, "*", lav$rhs),
                          paste(lav$lhs, lav$op, lav$ustart, "*", lav$rhs, 
                                "+", lav$label, "*", lav$rhs)
                   )
            )

    body <- paste(lav2, collapse="\n")
    paste(header, body, footer, sep="")
}

export_mplus <- function(lav) {
    stop("this function needs revision")
}

export_lisrel <- function(lav) {
    stop("this function needs revision")
}

export_eqs <- function(lav) {
    stop("this function needs revision")
}

export_sem <- function(lav) {
    stop("this function needs revision")
}

export_openmx <- function(lav) {
    stop("this function needs revision")
}

