% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsearch2.R
\name{modelsearch2}
\alias{modelsearch2}
\alias{modelsearch2.lvmfit}
\alias{modelsearch2.default}
\title{Data-driven Extension of a Latent Variable Model}
\usage{
modelsearch2(object, ...)

\method{modelsearch2}{lvmfit}(object, link = NULL, data = NULL,
  statistic = "Wald", method.p.adjust = "max", typeSD = "information",
  df = FALSE, adjust.residuals = FALSE, trace = TRUE, ...)

\method{modelsearch2}{default}(object, link, data = NULL,
  statistic = "Wald", method.p.adjust = "max", typeSD = "information",
  df = FALSE, adjust.residuals = FALSE, trace = TRUE, ...)
}
\arguments{
\item{object}{a \code{lvmfit} object.}

\item{...}{additional arguments to be passed to \code{\link{findNewLink}} and \code{.modelsearch2}, see details.}

\item{link}{the name of the additional relationships to consider when expanding the model. Should be a vector containing strings like "Y~X". Optional for \code{lvmfit} objects, see details.}

\item{data}{[optional] the dataset used to identify the model}

\item{statistic}{statistic used to perform the test. Can the likelihood ratio test (\code{"LR"}), the score (\code{"score"}) or the max statistic (\code{"max"}).}

\item{method.p.adjust}{the method used to adjust the p.values for multiple comparisons. Ignored when using the max statistic. Can be any method that is valid for the \code{stats::p.adjust} function (e.g. \code{"fdr"}).}

\item{typeSD}{[relevant when statistic is Wald] the type of standard error to be used to compute the Wald statistic.
Can be \code{"information"}, \code{"robust"} or \code{"jackknife"}.}

\item{df}{[relevant when statistic is Wald] small sample correction: should the degree of freedom be computed using the Satterthwaite approximation.}

\item{adjust.residuals}{[relevant when statistic is Wald] small sample correction: should the leverage-adjusted residuals be used to compute the influence function? Otherwise the raw residuals will be used.}

\item{trace}{should the execution be traced?}
}
\value{
a latent variable model
}
\description{
Procedure adding relationship between variables that are supported by the data.
}
\details{
Argument \code{link}:
\itemize{
\item \code{lvmfit} object: when not specified all possible additional links are considered.
\item other objects: this argument must be specified.
}

Argument \code{...} passed to \code{\link{findNewLink}}, see the documentation of this function:
\itemize{
\item exclude.var
\item rm.latent_latent
\item rm.endo_endo
\item rm.latent_endo
}

Argument \code{...} passed to \code{\link{modelsearch2}}:
\itemize{
\item alpha: the significance threshold for retaining a new link.
\item method.max: the method used to compute the distribution of the max statistic. See lava.options()$search.calcMaxDist.
\item ncpus: the number of cpus that can be used for the computations.
\item nStep: the maximum number of links that can be added to the model.
\item na.omit: should model leading to NA for the test statistic be ignored. Otherwise this will stop the selection process.
}
}
\examples{

#### linear regression ####
set.seed(10)
mSim <- lvm(Y~X1+X2+X3+X4)
addvar(mSim) <- ~Z1+Z2
df.data <- lava::sim(mSim, n = 1e2)
eLM <- lm(Y~X1, data = df.data)
possible.link <- c("Y~X2","Y~X3","Y~X4","Y~Z1","Y~Z2")

res <- modelsearch2(eLM, link = possible.link, data = df.data,
             statistic = "LR", method.p.adjust = "holm")
res <- modelsearch2(eLM, link = possible.link, data = df.data,
             statistic = "Wald", method.p.adjust = "holm", nStep = 1)
\dontrun{ 
res <- modelsearch2(eLM, data = df.data, link = possible.link)
}


#### Cox model ####
\dontrun{
library(survival)
data(Melanoma, package = "riskRegression")
m <- coxph(Surv(time,status==1)~ici+age, data = Melanoma, x = TRUE, y = TRUE)

res <- modelsearch2(m, link = c(status~epicel,status~sex),
                    packages = "survival", nStep = 1)
res
}

#### LVM ####
\dontrun{
mSim <- lvm()
regression(mSim) <- c(y1,y2,y3)~u
regression(mSim) <- u~x1+x2
categorical(mSim,labels=c("A","B","C")) <- "x2"
latent(mSim) <- ~u
covariance(mSim) <- y1~y2
transform(mSim, Id~u) <- function(x){1:NROW(x)}
df.data <- lava::sim(mSim, n = 1e2, latent = FALSE)

m <- lvm(c(y1,y2,y3)~u)
latent(m) <- ~u
addvar(m) <- ~x1+x2 

e <- estimate(m, df.data)

links <- c(u~x1,u~x2C,y3~x2C)
resScore <- modelsearch2(e, statistic = "score", link = links, method.p.adjust = "holm")
resLR <- modelsearch2(e, statistic = "LR", link = links, method.p.adjust = "holm", nStep = 1)
resMax <- modelsearch2(e, rm.endo_endo = TRUE, statistic = "Wald", link = links, nStep = 1)
resScore <- modelsearch2(e, statistic = "score", method.p.adjust = "holm")
resLR <- modelsearch2(e, statistic = "LR", method.p.adjust = "holm")
resMax <- modelsearch2(e, rm.endo_endo = TRUE, statistic = "Wald")
}

}
