% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sim.R
\name{plot.sim}
\alias{plot.sim}
\alias{density.sim}
\title{Plot method for simulation 'sim' objects}
\usage{
\method{plot}{sim}(x, estimate, se = NULL, true = NULL, names = NULL,
  auto.layout = TRUE, byrow = FALSE, type = "p",
  ask = grDevices::dev.interactive(), col = c("gray60", "orange",
  "darkblue", "seagreen", "darkred"), pch = 16, cex = 0.5, lty = 1,
  lwd = 0.3, legend, legendpos = "topleft", cex.legend = 0.8,
  plot.type = c("multiple", "single"), polygon = TRUE, density = 0,
  angle = -45, cex.axis = 0.8, alpha = 0.2, main, cex.main = 1,
  equal = FALSE, delta = 1.15, ylim = NULL, xlim = NULL,
  ylab = "", xlab = "", rug = TRUE, rug.alpha = 0.5,
  line.col = scatter.col, line.lwd = 1, line.lty = 1,
  line.alpha = 1, scatter.ylab = "Estimate", scatter.ylim = NULL,
  scatter.xlim = NULL, scatter.alpha = 0.5, scatter.col = col,
  border = col, true.lty = 2, true.col = "gray70", true.lwd = 1.2,
  density.plot = TRUE, scatter.plot = FALSE,
  running.mean = scatter.plot, ...)
}
\arguments{
\item{x}{sim object}

\item{estimate}{columns with estimates}

\item{se}{columns with standard error estimates}

\item{true}{(optional) vector of true parameter values}

\item{names}{(optional) names of estimates}

\item{auto.layout}{Auto layout (default TRUE)}

\item{byrow}{Add new plots to layout by row}

\item{type}{plot type}

\item{ask}{if TRUE user is asked for input, before a new figure is drawn}

\item{col}{colour (for each estimate)}

\item{pch}{plot symbol}

\item{cex}{point size}

\item{lty}{line type}

\item{lwd}{line width}

\item{legend}{legend}

\item{legendpos}{legend position}

\item{cex.legend}{size of legend text}

\item{plot.type}{'single' or 'multiple' (default)}

\item{polygon}{if TRUE fill the density estimates with colour}

\item{density}{if non-zero add shading lines to polygon}

\item{angle}{shading lines angle of polygon}

\item{cex.axis}{Font size on axis}

\item{alpha}{Semi-transparent level (1: non-transparent, 0: full)}

\item{main}{Main title}

\item{cex.main}{Size of title font}

\item{equal}{Same x-axis and y-axis for all plots}

\item{delta}{Controls the amount of space around axis limits}

\item{ylim}{y-axis limits}

\item{xlim}{x-axis limits}

\item{ylab}{y axis label}

\item{xlab}{x axis label}

\item{rug}{if TRUE add rug representation of data to x-axis}

\item{rug.alpha}{rug semi-transparency level}

\item{line.col}{line colour (running mean, only for scatter plots)}

\item{line.lwd}{line width (running mean, only for scatter plots)}

\item{line.lty}{line type (running mean, only for scatter plots)}

\item{line.alpha}{line transparency}

\item{scatter.ylab}{y label for density plots}

\item{scatter.ylim}{y-axis limits for density plots}

\item{scatter.xlim}{x-axis limits for density plots}

\item{scatter.alpha}{semi-transparency of scatter plot}

\item{scatter.col}{scatter plot colour}

\item{border}{border colour of density estimates}

\item{true.lty}{true parameter estimate line type}

\item{true.col}{true parameter colour}

\item{true.lwd}{true parameter line width}

\item{density.plot}{if TRUE add density plot}

\item{scatter.plot}{if TRUE add scatter plot}

\item{running.mean}{if TRUE add running average estimate to scatter plot}

\item{...}{additional arguments to lower level functions}
}
\description{
Density and scatter plots
}
\examples{
n <- 1000
val <- cbind(est1=rnorm(n,sd=1),est2=rnorm(n,sd=0.2),est3=rnorm(n,1,sd=0.5),
             sd1=runif(n,0.8,1.2),sd2=runif(n,0.1,0.3),sd3=runif(n,0.25,0.75))

plot.sim(val,estimate=c(1,2),true=c(0,0),se=c(4,5),equal=TRUE,scatter.plot=TRUE)
plot.sim(val,estimate=c(1,3),true=c(0,1),se=c(4,6),xlim=c(-3,3),
	scatter.ylim=c(-3,3),scatter.plot=TRUE)
plot.sim(val,estimate=c(1,2),true=c(0,0),se=c(4,5),equal=TRUE,
	plot.type="single",scatter.plot=TRUE)
plot.sim(val,estimate=c(1),se=c(4,5,6),plot.type="single",scatter.plot=TRUE)
plot.sim(val,estimate=c(1,2,3),equal=TRUE,scatter.plot=TRUE)
plot.sim(val,estimate=c(1,2,3),equal=TRUE,byrow=TRUE,scatter.plot=TRUE)
plot.sim(val,estimate=c(1,2,3),plot.type="single",scatter.plot=TRUE)
plot.sim(val,estimate=1,se=c(3,4,5),plot.type="single",scatter.plot=TRUE)

density.sim(val,estimate=c(1,2,3),density=c(0,10,10),angle=c(0,45,-45))
}
