% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.formLatticeOutput.R
\name{plot.formLatticeOutput}
\alias{plot.formLatticeOutput}
\title{Plot the lattice.}
\usage{
\method{plot}{formLatticeOutput}(x, ...)
}
\arguments{
\item{x}{An object of type formLatticeOutput returned 
by either formLattice or editLattice.}

\item{\dots}{Other arguments to be passed to functions 
plot, points, lines.}
}
\description{
This function plots the boundary, holes, 
nodes and neighbor lattice for the lattice 
based density or regression estimators. The 
plot can be examined to determine whether 
the lattice of connected nodes fills the region. 
If some nodes are connected when they should 
not be, or are disconnected when they should be 
connected, use editLattice to add or remove neighbor links.
}
\examples{
plot.new()
data(polygon1)
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.015)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)

}
\author{
Ronald P. Barry
}
