% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/model.R, R/models.R
\name{estimationTime}
\alias{estimationTime}
\alias{estimationTime,lcModel-method}
\alias{estimationTime,lcModels-method}
\alias{estimationTime,list-method}
\title{Estimation time}
\usage{
estimationTime(object, unit = "secs", ...)

\S4method{estimationTime}{lcModel}(object, unit = "secs", ...)

\S4method{estimationTime}{lcModels}(object, unit = "secs", ...)

\S4method{estimationTime}{list}(object, unit = "secs", ...)
}
\arguments{
\item{object}{The model.}

\item{unit}{The time unit in which the estimation time should be outputted.
By default, estimation time is in seconds.
For accepted units, see \link[base:difftime]{base::difftime}.}

\item{...}{Not used.}
}
\value{
A non-negative \verb{scalar numeric} representing the estimation time in the specified unit..
}
\description{
Get the elapsed time for estimating the given model.

For \code{lcModel}: Get the estimation time of the model, determined by the time taken for the associated \code{\link[=fit]{fit()}} function to finish.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)

estimationTime(model)
estimationTime(model, unit = 'mins')
estimationTime(model, unit = 'days')
}
\seealso{
Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
