% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{latrend-approaches}
\alias{latrend-approaches}
\title{High-level approaches to longitudinal clustering}
\description{
This page provides high-level guidelines on which methods are applicable to your dataset.
Note that this is intended as a quick-start.

Recommended overview and comparison papers:
\itemize{
\item \insertCite{denteuling2021clustering}{latrend}: A tutorial and overview on methods for longitudinal clustering.
\item \insertCite{denteuling2021comparison;textual}{latrend} compared KmL, MixTVEM, GBTM, GMM, and GCKM.
\item \insertCite{twisk2012classifying;textual}{latrend} compared KmL, GCKM, LLCA, GBTM and GMM.
\item \insertCite{verboon2022clustering;textual}{latrend} compared the \emph{kml}, \emph{traj} and \emph{lcmm} packages in R.
\item \insertCite{martin2015growth;textual}{latrend} compared KmL, LCA, and GMM.
}
}
\section{Approaches}{

Disclaimer: The table below has been adapted from a pre-print of \insertCite{denteuling2021clustering}{latrend}.\tabular{llll}{
   \strong{Approach} \tab \strong{Strengths} \tab \strong{Limitations} \tab \strong{Methods} \cr
   \strong{Cross-sectional clustering} \tab Suitable for large datasets — Many available algorithms — Non-parametric cluster trajectory representation \tab Requires time-aligned complete data — Sensitive to measurement noise \tab \link{lcMethodKML} \link{lcMethodMclustLLPA} \link{lcMethodMixtoolsNPRM} \cr
   \strong{Distance-based clustering} \tab Suitable for medium-sized datasets — Many distance metrics — Distance matrix only needs to be computed once \tab Scales poorly with number of trajectories — No robust cluster trajectory representation — Some distance metrics require aligned observations \tab \link{lcMethodDtwclust} \cr
   \strong{Feature-based clustering} \tab Suitable for large datasets — Configurable — Features only needs to be computed once — Compact trajectory representation \tab Generally requires intensive longitudinal data — Sensitive to outliers \tab \link{lcMethodFeature} \link{lcMethodAkmedoids} \link{lcMethodLMKM} \link{lcMethodGCKM} \cr
   \strong{Model-based clustering} \tab Parametric cluster trajectory — Incorporate (domain) assumptions — Low sample size requirements \tab Computationally intensive — Scales poorly with number of clusters — Convergence challenges \tab \link{lcMethodLcmmGBTM} \link{lcMethodLcmmGMM} \link{lcMethodCrimCV} \link{lcMethodFlexmix} \link{lcMethodFlexmixGBTM} \link{lcMethodFunFEM} \link{lcMethodMixAK_GLMM} \link{lcMethodMixtoolsGMM} \link{lcMethodMixTVEM} \cr
}


It is strongly encouraged to \link[=latrend-metrics]{evaluate and compare} several candidate methods in order to identify the most suitable method.
}

\references{
\insertAllCited{}
}
\seealso{
\link{latrend-methods} \link{latrend-estimation} \link{latrend-metrics}
}
