% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/method.R, R/model.R
\name{idVariable}
\alias{idVariable}
\alias{idVariable,lcMethod-method}
\alias{idVariable,lcModel-method}
\title{Extract the trajectory identifier variable}
\usage{
idVariable(object, ...)

\S4method{idVariable}{lcMethod}(object, ...)

\S4method{idVariable}{lcModel}(object)
}
\arguments{
\item{object}{The object.}

\item{...}{Not used.}
}
\value{
A nonempty string, as \code{character}.
}
\description{
Extracts the trajectory identifier variable (i.e., column name) from the given \code{object}.
}
\examples{
method <- lcMethodLMKM(Y ~ Time, id = "Traj")
idVariable(method) # "Traj"

method <- lcMethodRandom("Y", id = "Id", time = "Time")
model <- latrend(method, latrendData)
idVariable(model) # "Id"
}
\seealso{
Other variables: 
\code{\link{responseVariable}()},
\code{\link{timeVariable}()}
}
\concept{variables}
